/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flex2.compiler.CompilationUnit;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.Name;
import flex2.compiler.util.QName;
import flex2.linker.Linkable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CULinkable
implements Linkable {
    private final Set<String> defs = new HashSet<String>();
    private final Set<String> prereqs = new HashSet<String>();
    private final Set<String> deps = new HashSet<String>();
    private final CompilationUnit unit;

    public CULinkable(CompilationUnit unit) {
        this.unit = unit;
        assert (unit != null && unit.topLevelDefinitions != null) : "Must have missed a forcedToStop() check after the most recent batch()";
        this.defs.addAll(unit.topLevelDefinitions.getStringSet());
        this.addDeps(this.prereqs, unit.inheritance);
        this.addDeps(this.deps, unit.expressions);
        this.addDeps(this.deps, unit.namespaces);
        this.addDeps(this.deps, unit.types);
        this.deps.addAll(unit.extraClasses);
        this.deps.addAll(unit.resourceBundles);
    }

    @Override
    public String getName() {
        return this.unit.getSource().getName();
    }

    public CompilationUnit getUnit() {
        return this.unit;
    }

    @Override
    public long getLastModified() {
        return this.unit.getSource().getLastModified();
    }

    @Override
    public long getSize() {
        return this.unit.bytes.size();
    }

    public boolean hasDefinition(String defName) {
        return this.defs.contains(defName);
    }

    @Override
    public Iterator<String> getDefinitions() {
        return this.defs.iterator();
    }

    @Override
    public Iterator<String> getPrerequisites() {
        return this.prereqs.iterator();
    }

    @Override
    public Iterator<String> getDependencies() {
        return this.deps.iterator();
    }

    public String toString() {
        return this.unit.getSource().getName();
    }

    public void addDep(String val) {
        this.deps.add(val);
    }

    public boolean dependsOn(String s) {
        return this.deps.contains(s) || this.prereqs.contains(s);
    }

    @Override
    public boolean isNative() {
        return this.unit.getSource().isInternal();
    }

    private void addDeps(Set<String> set, Set<Name> nameSet) {
        for (Name name : nameSet) {
            if (name instanceof MultiName) {
                MultiName mname = (MultiName)name;
                assert (mname.getNumQNames() == 1);
                set.add(mname.getQName(0).toString());
                continue;
            }
            assert (name instanceof QName);
            set.add(name.toString());
        }
    }
}

