/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.fonts.FSType;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.table.Os2Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontLicenseChecker {
    public static void main(String[] args) throws Exception {
        FontLicenseChecker.listFonts(args);
    }

    public static void listFonts(String[] args) {
        File file = new File(args[0]);
        TreeMap<Integer, ArrayList<String>> fonts = new TreeMap<Integer, ArrayList<String>>();
        FontLicenseChecker.getLicenseTypes(file, fonts);
        for (Map.Entry<Integer, ArrayList<String>> entry : fonts.entrySet()) {
            Integer integ = entry.getKey();
            ArrayList<String> list = entry.getValue();
            FSType type = FSType.getFSType((int)integ);
            String licenseType = type.description + ", fsType = '" + type.fsType + "'";
            System.out.println("");
            System.out.println("---------");
            System.out.println(licenseType);
            System.out.println("Flex will" + (type.usableByFlex ? "" : " not") + " embed any of the " + list.size() + " fonts listed below.");
            System.out.println("");
            for (String fontStr : list) {
                System.out.println(fontStr);
            }
        }
    }

    public static void getLicenseTypes(File file, Map<Integer, ArrayList<String>> fonts) {
        if (!file.exists()) {
            throw new RuntimeException("Font or dir not found: " + file);
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    File child = children[i];
                    if (!child.isDirectory() && !child.toString().toLowerCase().endsWith(".ttf")) continue;
                    FontLicenseChecker.getLicenseTypes(child, fonts);
                }
            }
        } else {
            Font font = null;
            String err = null;
            try {
                font = Font.create((String)file.toString());
            }
            catch (Exception e) {
                err = e.toString();
            }
            if (font == null || font.getOS2Table() == null) {
                System.err.println("Error reading " + file + ": " + err);
            } else {
                Os2Table table = font.getOS2Table();
                Integer integ = new Integer(table.getLicenseType());
                ArrayList<String> list = fonts.get(integ);
                if (list == null) {
                    list = new ArrayList();
                    fonts.put(integ, list);
                }
                list.add(file.toString());
            }
        }
    }
}

