/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.MovieEncoder;
import flash.swf.TagDecoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.LicenseException;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.abc.AbcCompiler;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.EmbedExtension;
import flex2.compiler.as3.HostComponentExtension;
import flex2.compiler.as3.SignatureExtension;
import flex2.compiler.as3.SkinPartExtension;
import flex2.compiler.as3.StyleExtension;
import flex2.compiler.as3.binding.BindableExtension;
import flex2.compiler.as3.managed.ManagedExtension;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.css.CssCompiler;
import flex2.compiler.fxg.FXGCompiler;
import flex2.compiler.i18n.I18nCompiler;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.DataTranscoder;
import flex2.compiler.media.FontTranscoder;
import flex2.compiler.media.JPEGTranscoder;
import flex2.compiler.media.LosslessImageTranscoder;
import flex2.compiler.media.MovieTranscoder;
import flex2.compiler.media.PBJTranscoder;
import flex2.compiler.media.SVGTranscoder;
import flex2.compiler.media.SkinTranscoder;
import flex2.compiler.media.SoundTranscoder;
import flex2.compiler.media.XMLTranscoder;
import flex2.compiler.mxml.MxmlCompiler;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.Mxmlc;
import flex2.tools.PostLink;
import flex2.tools.PreLink;
import flex2.tools.Target;
import flex2.tools.Tool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class WebTierAPI
extends Tool {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Target compile(VirtualFile targetFile, Configuration configuration, SwcCache swcCache, Map licenseMap) throws CompilerException, LicenseException {
        Target target;
        Target target2 = new Target();
        try {
            try {
                if (configuration.benchmark()) {
                    CompilerAPI.runBenchmark();
                } else {
                    CompilerAPI.disableBenchmark();
                }
                target2.configuration = configuration;
                CompilerAPI.useAS3();
                CompilerAPI.usePathResolver();
                CompilerAPI.setupHeadless(configuration);
                LocalizationManager l10n = new LocalizationManager();
                l10n.addLocalizer((ILocalizer)new XLRLocalizer());
                l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
                ThreadLocalToolkit.setLocalizationManager(l10n);
                WebTierAPI.checkSupportedTargetMimeType(targetFile);
                ArrayList<VirtualFile> virtualFileList = new ArrayList<VirtualFile>();
                virtualFileList.add(targetFile);
                CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                NameMappings mappings = CompilerAPI.getNameMappings(configuration);
                Transcoder[] transcoders = WebTierAPI.getTranscoders(configuration);
                SubCompiler[] compilers = WebTierAPI.getCompilers(compilerConfig, mappings, transcoders);
                target2.fileSpec = new FileSpec(Collections.<VirtualFile>emptyList(), WebTierAPI.getFileSpecMimeTypes());
                VirtualFile[] asClasspath = compilerConfig.getSourcePath();
                target2.sourceList = new SourceList(virtualFileList, asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes());
                target2.sourcePath = new SourcePath(asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
                target2.resources = new ResourceContainer();
                target2.bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), targetFile);
                if (ThreadLocalToolkit.getBenchmark() != null) {
                    ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
                }
                CompilerSwcContext swcContext = new CompilerSwcContext();
                swcContext.load(compilerConfig.getLibraryPath(), Configuration.getAllExcludedLibraries(compilerConfig, configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat(compilerConfig), swcCache);
                configuration.addExterns(swcContext.getExterns());
                configuration.addIncludes(swcContext.getIncludes());
                configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
                CompilerAPI.validateCompilationUnits(target2.fileSpec, target2.sourceList, target2.sourcePath, target2.bundlePath, target2.resources, swcContext, null, false, configuration);
                SymbolTable symbolTable = new SymbolTable(configuration);
                target2.perCompileData = symbolTable.perCompileData;
                target2.units = CompilerAPI.compile(target2.fileSpec, target2.sourceList, null, target2.sourcePath, target2.resources, target2.bundlePath, swcContext, symbolTable, mappings, configuration, compilers, new PreLink(), licenseMap, new ArrayList<Source>());
                target = target2;
                Object var16_19 = null;
            }
            catch (LicenseException ex) {
                throw ex;
            }
            catch (CompilerException ex) {
                throw ex;
            }
            catch (Throwable t) {
                String message = t.getMessage();
                if (message == null) {
                    message = t.getClass().getName();
                }
                ThreadLocalToolkit.logError(message);
                throw new CompilerException(message);
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            CompilerAPI.removePathResolver();
            throw throwable;
        }
        CompilerAPI.removePathResolver();
        return target;
    }

    public static long optimize(InputStream in, OutputStream out, Configuration configuration) throws IOException {
        Movie movie = new Movie();
        TagDecoder tagDecoder = new TagDecoder(in);
        MovieDecoder movieDecoder = new MovieDecoder(movie);
        tagDecoder.parse((TagHandler)movieDecoder);
        WebTierAPI.optimize(movie, configuration);
        TagEncoder handler = new TagEncoder();
        MovieEncoder encoder = new MovieEncoder((TagHandler)handler);
        encoder.export(movie);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        handler.writeTo((OutputStream)baos);
        out.write(baos.toByteArray());
        return baos.size();
    }

    static void optimize(Movie m, Configuration configuration) {
        m.enableDebugger = null;
        m.uuid = null;
        PostLink postLink = configuration != null ? new PostLink(configuration) : new PostLink(false, true);
        postLink.run(m);
    }

    public static long optimize(InputStream in, OutputStream out) throws IOException {
        return WebTierAPI.optimize(in, out, null);
    }

    public static Transcoder[] getTranscoders(Configuration cfg) {
        return new Transcoder[]{new JPEGTranscoder(), new LosslessImageTranscoder(), new SVGTranscoder(cfg.getCompilerConfiguration().showDeprecationWarnings()), new SoundTranscoder(), new MovieTranscoder(), new FontTranscoder(cfg), new DataTranscoder(), new XMLTranscoder(), new SkinTranscoder(), new PBJTranscoder()};
    }

    public static SubCompiler[] getCompilers(CompilerConfiguration compilerConfig, NameMappings mappings, Transcoder[] transcoders) {
        As3Compiler asc = new As3Compiler(compilerConfig);
        if (!compilerConfig.getDisableIncrementalOptimizations()) {
            SignatureExtension.init(compilerConfig);
            asc.addCompilerExtension(SignatureExtension.getInstance());
        }
        String gendir = compilerConfig.keepGeneratedActionScript() ? compilerConfig.getGeneratedDirectory() : null;
        boolean generateAbstractSyntaxTree = compilerConfig.getGenerateAbstractSyntaxTree();
        asc.addCompilerExtension(new EmbedExtension(transcoders, gendir, compilerConfig.showDeprecationWarnings()));
        asc.addCompilerExtension(new StyleExtension());
        asc.addCompilerExtension(new HostComponentExtension());
        asc.addCompilerExtension(new BindableExtension(gendir, generateAbstractSyntaxTree, false));
        asc.addCompilerExtension(new ManagedExtension(gendir, generateAbstractSyntaxTree, compilerConfig.getServicesDependencies(), false));
        asc.addCompilerExtension(new SkinPartExtension());
        MxmlCompiler mxmlc = new MxmlCompiler(compilerConfig, compilerConfig, mappings, transcoders);
        AbcCompiler abc = new AbcCompiler(compilerConfig);
        abc.addCompilerExtension(new StyleExtension());
        FXGCompiler fxg = new FXGCompiler(compilerConfig, mappings);
        I18nCompiler prop = new I18nCompiler(compilerConfig, transcoders);
        CssCompiler css = new CssCompiler(compilerConfig, transcoders, mappings);
        return new SubCompiler[]{asc, mxmlc, abc, fxg, prop, css};
    }

    public static void checkSupportedTargetMimeType(VirtualFile targetFile) throws CompilerException {
        String[] mimeTypes = WebTierAPI.getTargetMimeTypes();
        int length = mimeTypes.length;
        for (int i = 0; i < length; ++i) {
            if (!mimeTypes[i].equals(targetFile.getMimeType())) continue;
            return;
        }
        SourceList.UnsupportedFileType ex = new SourceList.UnsupportedFileType(targetFile.getName());
        ThreadLocalToolkit.log(ex);
        throw ex;
    }

    public static String[] getFileSpecMimeTypes() {
        return new String[]{"text/as", "text/mxml", "text/fxg", "text/css", "application/x-actionscript-bytecode"};
    }

    public static String[] getSourceListMimeTypes() {
        return new String[]{"text/as", "text/mxml", "text/fxg", "text/css"};
    }

    public static String[] getSourcePathMimeTypes() {
        return new String[]{"text/as", "text/mxml", "text/fxg"};
    }

    public static String[] getTargetMimeTypes() {
        return new String[]{"text/as", "text/mxml", "text/css"};
    }
}

