/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;

@JsonPropertyOrder(value={"businessType", "financialInstitutionNumber", "mainSourceOfIncome", "type"})
public class TaxReportingClassification {
    public static final String JSON_PROPERTY_BUSINESS_TYPE = "businessType";
    private BusinessTypeEnum businessType;
    public static final String JSON_PROPERTY_FINANCIAL_INSTITUTION_NUMBER = "financialInstitutionNumber";
    private String financialInstitutionNumber;
    public static final String JSON_PROPERTY_MAIN_SOURCE_OF_INCOME = "mainSourceOfIncome";
    private MainSourceOfIncomeEnum mainSourceOfIncome;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public TaxReportingClassification businessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
        return this;
    }

    @JsonProperty(value="businessType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BusinessTypeEnum getBusinessType() {
        return this.businessType;
    }

    @JsonProperty(value="businessType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
    }

    public TaxReportingClassification financialInstitutionNumber(String financialInstitutionNumber) {
        this.financialInstitutionNumber = financialInstitutionNumber;
        return this;
    }

    @JsonProperty(value="financialInstitutionNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFinancialInstitutionNumber() {
        return this.financialInstitutionNumber;
    }

    @JsonProperty(value="financialInstitutionNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFinancialInstitutionNumber(String financialInstitutionNumber) {
        this.financialInstitutionNumber = financialInstitutionNumber;
    }

    public TaxReportingClassification mainSourceOfIncome(MainSourceOfIncomeEnum mainSourceOfIncome) {
        this.mainSourceOfIncome = mainSourceOfIncome;
        return this;
    }

    @JsonProperty(value="mainSourceOfIncome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MainSourceOfIncomeEnum getMainSourceOfIncome() {
        return this.mainSourceOfIncome;
    }

    @JsonProperty(value="mainSourceOfIncome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMainSourceOfIncome(MainSourceOfIncomeEnum mainSourceOfIncome) {
        this.mainSourceOfIncome = mainSourceOfIncome;
    }

    public TaxReportingClassification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxReportingClassification taxReportingClassification = (TaxReportingClassification)o;
        return Objects.equals((Object)this.businessType, (Object)taxReportingClassification.businessType) && Objects.equals(this.financialInstitutionNumber, taxReportingClassification.financialInstitutionNumber) && Objects.equals((Object)this.mainSourceOfIncome, (Object)taxReportingClassification.mainSourceOfIncome) && Objects.equals((Object)this.type, (Object)taxReportingClassification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.businessType, this.financialInstitutionNumber, this.mainSourceOfIncome, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxReportingClassification {\n");
        sb.append("    businessType: ").append(this.toIndentedString((Object)this.businessType)).append("\n");
        sb.append("    financialInstitutionNumber: ").append(this.toIndentedString(this.financialInstitutionNumber)).append("\n");
        sb.append("    mainSourceOfIncome: ").append(this.toIndentedString((Object)this.mainSourceOfIncome)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TaxReportingClassification fromJson(String jsonString) throws JsonProcessingException {
        return (TaxReportingClassification)JSON.getMapper().readValue(jsonString, TaxReportingClassification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        NONFINANCIALNONREPORTABLE(String.valueOf("nonFinancialNonReportable")),
        FINANCIALNONREPORTABLE(String.valueOf("financialNonReportable")),
        NONFINANCIALACTIVE(String.valueOf("nonFinancialActive")),
        NONFINANCIALPASSIVE(String.valueOf("nonFinancialPassive"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MainSourceOfIncomeEnum {
        BUSINESSOPERATION(String.valueOf("businessOperation")),
        REALESTATESALES(String.valueOf("realEstateSales")),
        INVESTMENTINTERESTORROYALTY(String.valueOf("investmentInterestOrRoyalty")),
        PROPERTYRENTAL(String.valueOf("propertyRental")),
        OTHER(String.valueOf("other"));

        private String value;

        private MainSourceOfIncomeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MainSourceOfIncomeEnum fromValue(String value) {
            for (MainSourceOfIncomeEnum b : MainSourceOfIncomeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum BusinessTypeEnum {
        OTHER(String.valueOf("other")),
        LISTEDPUBLICCOMPANY(String.valueOf("listedPublicCompany")),
        SUBSIDIARYOFLISTEDPUBLICCOMPANY(String.valueOf("subsidiaryOfListedPublicCompany")),
        GOVERNMENTALORGANIZATION(String.valueOf("governmentalOrganization")),
        INTERNATIONALORGANIZATION(String.valueOf("internationalOrganization")),
        FINANCIALINSTITUTION(String.valueOf("financialInstitution"));

        private String value;

        private BusinessTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BusinessTypeEnum fromValue(String value) {
            for (BusinessTypeEnum b : BusinessTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

