/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayfund;

import com.adyen.model.marketpayfund.JSON;
import com.adyen.model.marketpayfund.Transaction;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "hasNextPage", "transactions"})
public class AccountTransactionList {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_HAS_NEXT_PAGE = "hasNextPage";
    private Boolean hasNextPage;
    public static final String JSON_PROPERTY_TRANSACTIONS = "transactions";
    private List<Transaction> transactions = null;

    public AccountTransactionList accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public AccountTransactionList hasNextPage(Boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
        return this;
    }

    @ApiModelProperty(value="Indicates whether there is a next page of transactions available.")
    @JsonProperty(value="hasNextPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasNextPage() {
        return this.hasNextPage;
    }

    @JsonProperty(value="hasNextPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasNextPage(Boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public AccountTransactionList transactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public AccountTransactionList addTransactionsItem(Transaction transactionsItem) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<Transaction>();
        }
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(value="The list of transactions.")
    @JsonProperty(value="transactions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @JsonProperty(value="transactions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountTransactionList accountTransactionList = (AccountTransactionList)o;
        return Objects.equals(this.accountCode, accountTransactionList.accountCode) && Objects.equals(this.hasNextPage, accountTransactionList.hasNextPage) && Objects.equals(this.transactions, accountTransactionList.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.hasNextPage, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountTransactionList {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    hasNextPage: ").append(this.toIndentedString(this.hasNextPage)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountTransactionList fromJson(String jsonString) throws JsonProcessingException {
        return (AccountTransactionList)JSON.getMapper().readValue(jsonString, AccountTransactionList.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

