/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.storedvalue;

import com.adyen.model.storedvalue.Amount;
import com.adyen.model.storedvalue.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "merchantAccount", "paymentMethod", "recurringDetailReference", "reference", "shopperInteraction", "shopperReference", "status", "store"})
public class StoredValueStatusChangeRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private Map<String, String> paymentMethod;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;

    public StoredValueStatusChangeRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public StoredValueStatusChangeRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoredValueStatusChangeRequest paymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public StoredValueStatusChangeRequest putPaymentMethodItem(String key, String paymentMethodItem) {
        if (this.paymentMethod == null) {
            this.paymentMethod = new HashMap<String, String>();
        }
        this.paymentMethod.put(key, paymentMethodItem);
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public StoredValueStatusChangeRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public StoredValueStatusChangeRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public StoredValueStatusChangeRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public StoredValueStatusChangeRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public StoredValueStatusChangeRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public StoredValueStatusChangeRequest store(String store) {
        this.store = store;
        return this;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredValueStatusChangeRequest storedValueStatusChangeRequest = (StoredValueStatusChangeRequest)o;
        return Objects.equals(this.amount, storedValueStatusChangeRequest.amount) && Objects.equals(this.merchantAccount, storedValueStatusChangeRequest.merchantAccount) && Objects.equals(this.paymentMethod, storedValueStatusChangeRequest.paymentMethod) && Objects.equals(this.recurringDetailReference, storedValueStatusChangeRequest.recurringDetailReference) && Objects.equals(this.reference, storedValueStatusChangeRequest.reference) && Objects.equals((Object)this.shopperInteraction, (Object)storedValueStatusChangeRequest.shopperInteraction) && Objects.equals(this.shopperReference, storedValueStatusChangeRequest.shopperReference) && Objects.equals((Object)this.status, (Object)storedValueStatusChangeRequest.status) && Objects.equals(this.store, storedValueStatusChangeRequest.store);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.merchantAccount, this.paymentMethod, this.recurringDetailReference, this.reference, this.shopperInteraction, this.shopperReference, this.status, this.store});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredValueStatusChangeRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredValueStatusChangeRequest fromJson(String jsonString) throws JsonProcessingException {
        return (StoredValueStatusChangeRequest)JSON.getMapper().readValue(jsonString, StoredValueStatusChangeRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("active")),
        INACTIVE(String.valueOf("inactive"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE(String.valueOf("Ecommerce")),
        CONTAUTH(String.valueOf("ContAuth")),
        MOTO(String.valueOf("Moto")),
        POS(String.valueOf("POS"));

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

