/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.ResultCode;
import com.aerospike.client.cluster.Node;

public class AerospikeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int resultCode;

    public AerospikeException(int resultCode, String message) {
        super(message);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, Throwable e) {
        super(e);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode) {
        this.resultCode = resultCode;
    }

    public AerospikeException(String message, Throwable e) {
        super(message, e);
    }

    public AerospikeException(String message) {
        super(message);
    }

    public AerospikeException(Throwable e) {
        super(e);
    }

    public AerospikeException() {
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String message = super.getMessage();
        if (this.resultCode != 0) {
            sb.append("Error Code ");
            sb.append(this.resultCode);
            sb.append(": ");
            if (message != null) {
                sb.append(message);
            } else {
                sb.append(ResultCode.getResultString(this.resultCode));
            }
        } else if (message != null) {
            sb.append(message);
        } else {
            sb.append(this.getClass().getName());
        }
        return sb.toString();
    }

    public final boolean keepConnection() {
        return ResultCode.keepConnection(this.resultCode);
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public static final class CommandRejected
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public CommandRejected() {
            super(-6);
        }
    }

    public static final class QueryTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public QueryTerminated() {
            super(-5);
        }

        public QueryTerminated(Exception e) {
            super(-5, (Throwable)e);
        }
    }

    public static final class ScanTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public ScanTerminated() {
            super(-4);
        }

        public ScanTerminated(Exception e) {
            super(-4, (Throwable)e);
        }
    }

    public static final class InvalidNode
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public InvalidNode() {
            super(-3);
        }

        public InvalidNode(String message) {
            super(-3, message);
        }
    }

    public static final class Connection
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Connection(String message) {
            super(11, message);
        }

        public Connection(Exception e) {
            super(11, (Throwable)e);
        }

        public Connection(int resultCode, String message) {
            super(resultCode, message);
        }
    }

    public static final class Parse
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Parse(String message) {
            super(-2, message);
        }
    }

    public static final class Serialize
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Serialize(Exception e) {
            super(-1, (Throwable)e);
        }
    }

    public static final class Timeout
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public Node node;
        public int timeout;
        public int iterations;
        public boolean client;

        public Timeout() {
            super(9);
            this.timeout = -1;
            this.client = true;
        }

        public Timeout(Node node, int timeout, int iterations, boolean client) {
            super(9);
            this.node = node;
            this.timeout = timeout;
            this.iterations = iterations;
            this.client = client;
        }

        @Override
        public String getMessage() {
            if (this.timeout == -1) {
                return super.getMessage();
            }
            return "Client timeout: timeout=" + this.timeout + " iterations=" + this.iterations + " lastNode=" + this.node;
        }
    }
}

