/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import java.util.ArrayList;

public final class Host {
    public final String name;
    public final String tlsName;
    public final int port;

    public Host(String name, int port) {
        this.name = name;
        this.tlsName = null;
        this.port = port;
    }

    public Host(String name, String tlsName, int port) {
        this.name = name;
        this.tlsName = tlsName;
        this.port = port;
    }

    public String toString() {
        return this.name + ' ' + this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.name.hashCode();
        return 31 * result + this.port;
    }

    public boolean equals(Object obj) {
        Host other = (Host)obj;
        return this.name.equals(other.name) && this.port == other.port;
    }

    public static Host[] parseHosts(String str, int defaultPort) {
        try {
            return new HostParser(str, defaultPort).hosts;
        }
        catch (Exception e) {
            throw new AerospikeException("Invalid hosts string: " + str);
        }
    }

    private static class HostParser {
        private Host[] hosts;
        private String str;
        private int offset;
        private int length;
        private char c;

        private HostParser(String str, int defaultPort) {
            this.str = str;
            this.length = str.length();
            this.offset = 0;
            this.c = (char)44;
            ArrayList<Host> list = new ArrayList<Host>();
            while (this.offset < this.length) {
                String s;
                if (this.c != ',') {
                    throw new RuntimeException();
                }
                String hostname = this.parseHost();
                String tlsname = null;
                int port = defaultPort;
                if (this.offset < this.length && this.c == ':' && (s = this.parseString()).length() > 0) {
                    if (Character.isDigit(s.charAt(0))) {
                        port = Integer.parseInt(s);
                    } else {
                        tlsname = s;
                        s = this.parseString();
                        if (s.length() > 0) {
                            port = Integer.parseInt(s);
                        }
                    }
                }
                list.add(new Host(hostname, tlsname, port));
            }
            this.hosts = list.toArray(new Host[list.size()]);
        }

        private String parseHost() {
            this.c = this.str.charAt(this.offset);
            if (this.c == '[') {
                int begin = ++this.offset;
                while (this.offset < this.length) {
                    this.c = this.str.charAt(this.offset);
                    if (this.c == ']') {
                        String s = this.str.substring(begin, this.offset++);
                        if (this.offset < this.length) {
                            this.c = this.str.charAt(this.offset++);
                        }
                        return s;
                    }
                    ++this.offset;
                }
                throw new RuntimeException("Unterminated bracket");
            }
            return this.parseString();
        }

        private String parseString() {
            int begin = this.offset;
            while (this.offset < this.length) {
                this.c = this.str.charAt(this.offset);
                if (this.c == ':' || this.c == ',') {
                    return this.str.substring(begin, this.offset++);
                }
                ++this.offset;
            }
            return this.str.substring(begin, this.offset);
        }
    }
}

