/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AsyncMultiExecutor {
    private final EventLoop eventLoop;
    private final Cluster cluster;
    private final AtomicInteger completedCount = new AtomicInteger();
    private final AtomicBoolean done = new AtomicBoolean();
    private AsyncMultiCommand[] commands;
    private int maxConcurrent;

    public AsyncMultiExecutor(EventLoop eventLoop, Cluster cluster) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
    }

    public void execute(AsyncMultiCommand[] commands, int maxConcurrent) {
        this.commands = commands;
        this.maxConcurrent = maxConcurrent == 0 || maxConcurrent >= commands.length ? commands.length : maxConcurrent;
        for (int i = 0; i < this.maxConcurrent; ++i) {
            this.eventLoop.execute(this.cluster, commands[i]);
        }
    }

    protected final void childSuccess() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.commands.length) {
            int nextThread = finished + this.maxConcurrent - 1;
            if (nextThread < this.commands.length && !this.done.get()) {
                this.eventLoop.execute(this.cluster, this.commands[nextThread]);
            }
        } else if (this.done.compareAndSet(false, true)) {
            this.onSuccess();
        }
    }

    protected final void childFailure(AerospikeException ae) {
        if (this.done.compareAndSet(false, true)) {
            for (AsyncMultiCommand command : this.commands) {
                command.stop();
            }
            this.onFailure(ae);
        }
    }

    protected abstract void onSuccess();

    protected abstract void onFailure(AerospikeException var1);
}

