/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.util.Packer;
import java.util.List;

public class ListOperation {
    private static final int APPEND = 1;
    private static final int APPEND_ITEMS = 2;
    private static final int INSERT = 3;
    private static final int INSERT_ITEMS = 4;
    private static final int POP = 5;
    private static final int POP_RANGE = 6;
    private static final int REMOVE = 7;
    private static final int REMOVE_RANGE = 8;
    private static final int SET = 9;
    private static final int TRIM = 10;
    private static final int CLEAR = 11;
    private static final int SIZE = 16;
    private static final int GET = 17;
    private static final int GET_RANGE = 18;

    public static Operation append(String binName, Value value) {
        Packer packer = new Packer();
        packer.packRawShort(1);
        packer.packArrayBegin(1);
        value.pack(packer);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation appendItems(String binName, List<Value> list) {
        Packer packer = new Packer();
        packer.packRawShort(2);
        packer.packArrayBegin(1);
        packer.packValueList(list);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation insert(String binName, int index2, Value value) {
        Packer packer = new Packer();
        packer.packRawShort(3);
        packer.packArrayBegin(2);
        packer.packInt(index2);
        value.pack(packer);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation insertItems(String binName, int index2, List<Value> list) {
        Packer packer = new Packer();
        packer.packRawShort(4);
        packer.packArrayBegin(2);
        packer.packInt(index2);
        packer.packValueList(list);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation pop(String binName, int index2) {
        Packer packer = new Packer();
        packer.packRawShort(5);
        packer.packArrayBegin(1);
        packer.packInt(index2);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation popRange(String binName, int index2, int count) {
        Packer packer = new Packer();
        packer.packRawShort(6);
        packer.packArrayBegin(2);
        packer.packInt(index2);
        packer.packInt(count);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation popRange(String binName, int index2) {
        Packer packer = new Packer();
        packer.packRawShort(6);
        packer.packArrayBegin(1);
        packer.packInt(index2);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation remove(String binName, int index2) {
        Packer packer = new Packer();
        packer.packRawShort(7);
        packer.packArrayBegin(1);
        packer.packInt(index2);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeRange(String binName, int index2, int count) {
        Packer packer = new Packer();
        packer.packRawShort(8);
        packer.packArrayBegin(2);
        packer.packInt(index2);
        packer.packInt(count);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation removeRange(String binName, int index2) {
        Packer packer = new Packer();
        packer.packRawShort(8);
        packer.packArrayBegin(1);
        packer.packInt(index2);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation set(String binName, int index2, Value value) {
        Packer packer = new Packer();
        packer.packRawShort(9);
        packer.packArrayBegin(2);
        packer.packInt(index2);
        value.pack(packer);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation trim(String binName, int index2, int count) {
        Packer packer = new Packer();
        packer.packRawShort(10);
        packer.packArrayBegin(2);
        packer.packInt(index2);
        packer.packInt(count);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation clear(String binName) {
        Packer packer = new Packer();
        packer.packRawShort(11);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(bytes));
    }

    public static Operation size(String binName) {
        Packer packer = new Packer();
        packer.packRawShort(16);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation get(String binName, int index2) {
        Packer packer = new Packer();
        packer.packRawShort(17);
        packer.packArrayBegin(1);
        packer.packInt(index2);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getRange(String binName, int index2, int count) {
        Packer packer = new Packer();
        packer.packRawShort(18);
        packer.packArrayBegin(2);
        packer.packInt(index2);
        packer.packInt(count);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }

    public static Operation getRange(String binName, int index2) {
        Packer packer = new Packer();
        packer.packRawShort(18);
        packer.packArrayBegin(1);
        packer.packInt(index2);
        byte[] bytes = packer.toByteArray();
        return new Operation(Operation.Type.CDT_READ, binName, Value.get(bytes));
    }
}

