/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.NettyCommand;
import com.aerospike.client.async.NettyEventLoops;
import com.aerospike.client.async.ScheduleTask;
import com.aerospike.client.cluster.Cluster;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;

public final class NettyEventLoop
implements EventLoop {
    final io.netty.channel.EventLoop eventLoop;
    final ArrayDeque<byte[]> bufferQueue;
    final HashedWheelTimer timer;
    final NettyEventLoops parent;
    final int index;

    public NettyEventLoop(EventPolicy policy, io.netty.channel.EventLoop eventLoop, NettyEventLoops parent, int index2) {
        this.eventLoop = eventLoop;
        this.parent = parent;
        this.index = index2;
        this.bufferQueue = new ArrayDeque(policy.commandsPerEventLoop);
        this.timer = new HashedWheelTimer(this, policy.minTimeout, TimeUnit.MILLISECONDS, policy.ticksPerWheel);
    }

    public io.netty.channel.EventLoop get() {
        return this.eventLoop;
    }

    @Override
    public void execute(Cluster cluster, AsyncCommand command) {
        new NettyCommand(this, cluster, command);
    }

    @Override
    public void execute(Runnable command) {
        this.eventLoop.execute(command);
    }

    @Override
    public void schedule(Runnable command, long delay, TimeUnit unit) {
        this.eventLoop.schedule(command, delay, unit);
    }

    @Override
    public void schedule(ScheduleTask task, long delay, TimeUnit unit) {
        this.eventLoop.schedule((Runnable)task, delay, unit);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean inEventLoop() {
        return this.eventLoop.inEventLoop();
    }

    @Override
    public EventState createState() {
        return new EventState(this, this.index);
    }
}

