/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.NioConnection;
import com.aerospike.client.async.NioEventLoop;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public final class NioCommand
implements Runnable,
TimerTask {
    final NioEventLoop eventLoop;
    final Cluster cluster;
    final AsyncCommand command;
    final EventState eventState;
    NioConnection conn;
    ByteBuffer byteBuffer;
    HashedWheelTimer.HashedWheelTimeout timeoutTask;
    long totalDeadline;
    int state;
    int iteration;
    int receiveSize;
    final boolean hasTotalTimeout;
    boolean usingSocketTimeout;
    boolean eventReceived;
    boolean timeoutDelay;

    public NioCommand(NioEventLoop eventLoop, Cluster cluster, AsyncCommand command) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
        this.eventState = cluster.eventState[eventLoop.index];
        this.command = command;
        command.bufferQueue = eventLoop.bufferQueue;
        boolean bl = this.hasTotalTimeout = command.policy.totalTimeout > 0;
        if (eventLoop == Thread.currentThread() && this.eventState.errors < 5) {
            this.run();
        } else {
            if (this.hasTotalTimeout) {
                this.totalDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(command.policy.totalTimeout);
            }
            this.state = 1;
            eventLoop.execute(this);
        }
    }

    @Override
    public void run() {
        if (this.eventState.pending++ == -1) {
            this.eventState.pending = -1;
            ++this.eventState.errors;
            this.state = 8;
            this.notifyFailure(new AerospikeException("Cluster has been closed"));
            return;
        }
        if (this.hasTotalTimeout) {
            long deadline;
            long currentTime = System.nanoTime();
            if (this.state == 1) {
                if (currentTime >= this.totalDeadline) {
                    --this.eventState.pending;
                    ++this.eventState.errors;
                    this.state = 8;
                    this.notifyFailure(new AerospikeException.Timeout(null, this.command.policy, this.iteration, true));
                    return;
                }
            } else {
                this.totalDeadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.totalTimeout);
            }
            if (this.command.policy.socketTimeout > 0) {
                deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
                if (deadline < this.totalDeadline) {
                    this.usingSocketTimeout = true;
                } else {
                    deadline = this.totalDeadline;
                }
            } else {
                deadline = this.totalDeadline;
            }
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, deadline);
        } else if (this.command.policy.socketTimeout > 0) {
            this.usingSocketTimeout = true;
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout));
        }
        this.executeCommand();
    }

    protected final void executeCommand() {
        try {
            Node node = this.command.getNode(this.cluster);
            this.byteBuffer = this.eventLoop.getByteBuffer();
            this.conn = (NioConnection)node.getAsyncConnection(this.eventLoop.index, this.byteBuffer);
            if (this.conn != null) {
                this.conn.attach(this);
                this.writeCommand();
                return;
            }
            try {
                this.conn = new NioConnection(node.getAddress());
            }
            catch (Exception e) {
                node.decrAsyncConnection(this.eventLoop.index);
                throw e;
            }
            this.state = this.cluster.getUser() != null ? 2 : 5;
            this.conn.registerConnect(this);
            this.eventState.errors = 0;
        }
        catch (AerospikeException.Connection ac) {
            ++this.eventState.errors;
            this.onNetworkError(ac, true);
        }
        catch (IOException ioe) {
            ++this.eventState.errors;
            this.onNetworkError(new AerospikeException(ioe), true);
        }
        catch (Exception e) {
            ++this.eventState.errors;
            this.fail();
            this.notifyFailure(new AerospikeException(e));
        }
    }

    protected final void finishConnect() throws IOException {
        this.conn.finishConnect();
        if (this.state == 2) {
            this.writeAuth();
        } else {
            this.writeCommand();
        }
    }

    private final void writeAuth() throws IOException {
        this.command.initBuffer();
        AdminCommand admin = new AdminCommand(this.command.dataBuffer);
        this.command.dataOffset = admin.setAuthenticate(this.cluster.getUser(), this.cluster.getPassword());
        this.byteBuffer.clear();
        this.byteBuffer.put(this.command.dataBuffer, 0, this.command.dataOffset);
        this.byteBuffer.flip();
        this.command.putBuffer();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 3;
            this.eventReceived = false;
            this.conn.registerRead();
        } else {
            this.state = 2;
            this.conn.registerWrite();
        }
    }

    private final void writeCommand() throws IOException {
        this.command.writeBuffer();
        if (this.command.dataOffset > this.byteBuffer.capacity()) {
            this.byteBuffer = NioEventLoop.createByteBuffer(this.command.dataOffset);
        }
        this.byteBuffer.clear();
        this.byteBuffer.put(this.command.dataBuffer, 0, this.command.dataOffset);
        this.byteBuffer.flip();
        this.command.putBuffer();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 6;
            this.eventReceived = false;
            this.conn.registerRead();
        } else {
            this.state = 5;
            this.conn.registerWrite();
        }
    }

    protected final void write() throws IOException {
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = this.state == 5 ? 6 : 3;
            this.eventReceived = false;
            this.conn.registerRead();
        }
    }

    protected final void read() throws IOException {
        this.eventReceived = true;
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        switch (this.state) {
            case 3: {
                this.readAuthHeader();
                if (!this.conn.read(this.byteBuffer)) {
                    return;
                }
            }
            case 4: {
                this.readAuthBody();
                this.writeCommand();
                break;
            }
            case 6: {
                if (this.command.partition != null) {
                    this.readSingleHeader();
                    break;
                }
                this.readMultiHeader();
                break;
            }
            case 7: {
                if (this.command.partition != null) {
                    this.readSingleBody();
                    break;
                }
                this.readMultiBody();
            }
        }
    }

    private final void readAuthHeader() {
        this.byteBuffer.position(0);
        this.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (this.receiveSize < 2 || this.receiveSize > this.byteBuffer.capacity()) {
            throw new AerospikeException.Parse("Invalid auth receive size: " + this.receiveSize);
        }
        this.byteBuffer.clear();
        this.byteBuffer.limit(this.receiveSize);
        this.state = 4;
    }

    private final void readAuthBody() {
        int resultCode = this.byteBuffer.get(1) & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
    }

    private final void readSingleHeader() throws IOException {
        this.byteBuffer.position(0);
        this.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (this.receiveSize < 22) {
            throw new AerospikeException.Parse("Invalid receive size: " + this.receiveSize);
        }
        if (this.receiveSize <= this.byteBuffer.capacity()) {
            this.byteBuffer.clear();
        } else {
            this.byteBuffer = NioEventLoop.createByteBuffer(this.receiveSize);
        }
        this.byteBuffer.limit(this.receiveSize);
        this.state = 7;
        if (this.conn.read(this.byteBuffer)) {
            this.readSingleBody();
        }
    }

    private final void readSingleBody() {
        if (this.command.readAll) {
            this.command.sizeBuffer(this.receiveSize);
            this.byteBuffer.position(0);
            this.byteBuffer.get(this.command.dataBuffer, 0, this.receiveSize);
            this.command.resultCode = this.command.dataBuffer[5] & 0xFF;
            ((AsyncSingleCommand)((Object)this.command)).parseResult();
            this.command.putBuffer();
        } else {
            this.command.resultCode = this.byteBuffer.get(5) & 0xFF;
            ((AsyncSingleCommand)((Object)this.command)).parseResult();
        }
        this.finish();
    }

    private final void readMultiHeader() throws IOException {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.parseGroupHeader()) {
            return;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        this.readMultiBody();
    }

    private final void readMultiBody() throws IOException {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.parseGroupBody()) {
            return;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        if (!this.parseGroupHeader()) {
            return;
        }
        if (this.receiveSize == 22) {
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            this.parseGroupBody();
        }
    }

    private final boolean parseGroupHeader() {
        this.byteBuffer.position(0);
        this.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (this.receiveSize <= 0) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 6;
            return false;
        }
        this.command.sizeBuffer(this.receiveSize);
        this.command.dataOffset = 0;
        this.byteBuffer.clear();
        if (this.receiveSize < this.byteBuffer.capacity()) {
            this.byteBuffer.limit(this.receiveSize);
        }
        this.state = 7;
        return true;
    }

    private final boolean parseGroupBody() throws IOException {
        do {
            this.byteBuffer.position(0);
            this.byteBuffer.get(this.command.dataBuffer, this.command.dataOffset, this.byteBuffer.limit());
            this.command.dataOffset += this.byteBuffer.limit();
            this.byteBuffer.clear();
            if (this.command.dataOffset >= this.receiveSize) {
                if (((AsyncMultiCommand)this.command).parseGroup(this.receiveSize)) {
                    this.finish();
                    return false;
                }
                this.byteBuffer.limit(8);
                this.command.dataOffset = 0;
                this.state = 6;
                return true;
            }
            int remaining = this.receiveSize - this.command.dataOffset;
            if (remaining >= this.byteBuffer.capacity()) continue;
            this.byteBuffer.limit(remaining);
        } while (this.conn.read(this.byteBuffer));
        return false;
    }

    @Override
    public final void timeout() {
        if (this.state == 8) {
            return;
        }
        if (this.timeoutDelay) {
            this.timeoutTask = null;
            this.fail();
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (currentTime >= this.totalDeadline) {
                ++this.iteration;
                this.totalTimeout();
                return;
            }
            if (this.usingSocketTimeout && this.eventReceived) {
                this.eventReceived = false;
                long deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
                if (deadline >= this.totalDeadline) {
                    deadline = this.totalDeadline;
                    this.usingSocketTimeout = false;
                }
                this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
                return;
            }
        } else if (this.eventReceived) {
            this.eventReceived = false;
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, socketDeadline);
            return;
        }
        if (++this.iteration > this.command.policy.maxRetries) {
            this.totalTimeout();
            return;
        }
        this.closeConnection();
        if (this.command.isRead) {
            ++this.command.sequence;
        }
        long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
        if (this.hasTotalTimeout) {
            long remaining = this.totalDeadline - currentTime;
            if (remaining <= timeout) {
                timeout = remaining;
                this.usingSocketTimeout = false;
            }
        } else {
            currentTime = System.nanoTime();
        }
        this.eventLoop.timer.restoreTimeout(this.timeoutTask, currentTime + timeout);
        this.executeCommand();
    }

    private final void totalTimeout() {
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.node, this.command.policy, this.iteration, true);
        if (this.command.policy.timeoutDelay > 0) {
            this.timeoutDelay = true;
            this.notifyFailure(ae);
            this.totalDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.timeoutDelay);
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, this.totalDeadline);
            return;
        }
        this.timeoutTask = null;
        this.fail();
        this.notifyFailure(ae);
    }

    protected final void finish() {
        this.complete();
        if (this.timeoutDelay) {
            return;
        }
        try {
            this.command.onSuccess();
        }
        catch (Exception e) {
            Log.error("onSuccess() error: " + Util.getErrorMessage(e));
        }
    }

    protected final void onNetworkError(AerospikeException ae, boolean queueCommand) {
        this.closeConnection();
        ++this.command.sequence;
        this.retry(ae, queueCommand);
    }

    protected final void onServerTimeout() {
        this.conn.unregister();
        this.command.node.putAsyncConnection(this.conn, this.eventLoop.index);
        if (this.command.isRead) {
            ++this.command.sequence;
        }
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.node, this.command.policy, this.iteration, false);
        this.retry(ae, false);
    }

    private final void retry(AerospikeException ae, boolean queueCommand) {
        if (this.timeoutDelay) {
            this.close();
            return;
        }
        if (++this.iteration > this.command.policy.maxRetries) {
            this.close();
            this.notifyFailure(ae);
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout && (currentTime = System.nanoTime()) >= this.totalDeadline) {
            this.close();
            this.notifyFailure(ae);
            return;
        }
        if (this.usingSocketTimeout) {
            this.timeoutTask.cancel();
            long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
            if (this.hasTotalTimeout) {
                long remaining = this.totalDeadline - currentTime;
                if (remaining <= timeout) {
                    timeout = remaining;
                    this.usingSocketTimeout = false;
                }
            } else {
                currentTime = System.nanoTime();
            }
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, currentTime + timeout);
        }
        if (queueCommand) {
            this.eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    if (NioCommand.this.state == 8) {
                        return;
                    }
                    if (NioCommand.this.timeoutDelay) {
                        NioCommand.this.close();
                        return;
                    }
                    NioCommand.this.executeCommand();
                }
            });
        } else {
            this.executeCommand();
        }
    }

    protected final void onApplicationError(AerospikeException ae) {
        if (ae.keepConnection()) {
            this.complete();
        } else {
            this.fail();
        }
        if (!this.timeoutDelay) {
            this.notifyFailure(ae);
        }
    }

    private final void notifyFailure(AerospikeException ae) {
        try {
            this.command.onFailure(ae);
        }
        catch (Exception e) {
            Log.error("onFailure() error: " + Util.getErrorMessage(e));
        }
    }

    private final void complete() {
        this.conn.unregister();
        this.command.node.putAsyncConnection(this.conn, this.eventLoop.index);
        this.close();
    }

    private final void fail() {
        this.closeConnection();
        this.close();
    }

    private final void closeConnection() {
        if (this.conn != null) {
            this.command.node.closeAsyncConnection(this.conn, this.eventLoop.index);
            this.conn = null;
        }
    }

    private final void close() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
        }
        this.command.putBuffer();
        --this.eventState.pending;
        this.state = 8;
    }
}

