/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.async.NioCommand;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public final class NioConnection
implements AsyncConnection,
Closeable {
    private final SocketChannel socketChannel;
    private SelectionKey key;

    public NioConnection(InetSocketAddress address) {
        try {
            this.socketChannel = SocketChannel.open();
        }
        catch (Exception e) {
            throw new AerospikeException.Connection("SocketChannel open error: " + e.getMessage());
        }
        try {
            this.socketChannel.configureBlocking(false);
            Socket socket = this.socketChannel.socket();
            socket.setTcpNoDelay(true);
            this.socketChannel.connect(address);
        }
        catch (Exception e) {
            this.close();
            throw new AerospikeException.Connection("SocketChannel init error: " + e.getMessage());
        }
    }

    public void registerConnect(NioCommand command) {
        try {
            this.key = this.socketChannel.register(command.eventLoop.selector, 8, command);
        }
        catch (ClosedChannelException e) {
            throw new AerospikeException.Connection("SocketChannel register error: " + e.getMessage());
        }
    }

    public void finishConnect() throws IOException {
        this.socketChannel.finishConnect();
    }

    public void attach(NioCommand command) {
        this.key.attach(command);
    }

    public void registerWrite() {
        this.key.interestOps(4);
    }

    public boolean write(ByteBuffer byteBuffer) throws IOException {
        this.socketChannel.write(byteBuffer);
        return !byteBuffer.hasRemaining();
    }

    public void registerRead() {
        this.key.interestOps(1);
    }

    public boolean read(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            int len = this.socketChannel.read(byteBuffer);
            if (len == 0) {
                return false;
            }
            if (len >= 0) continue;
            throw new EOFException();
        }
        return true;
    }

    @Override
    public boolean isValid(ByteBuffer byteBuffer) {
        byteBuffer.position(0);
        byteBuffer.limit(1);
        try {
            return this.socketChannel.read(byteBuffer) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void unregister() {
        this.key.interestOps(0);
        this.key.attach(null);
    }

    @Override
    public void close() {
        block3: {
            if (this.key != null) {
                this.key.cancel();
            }
            try {
                this.socketChannel.close();
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) break block3;
                Log.debug("Error closing socket: " + Util.getErrorMessage(e));
            }
        }
    }
}

