/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.Language;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.task.RegisterTask;
import com.aerospike.client.util.Environment;
import gnu.crypto.util.Base64;

public final class RegisterCommand {
    public static RegisterTask register(Cluster cluster, Policy policy, byte[] bytes, String serverPath, Language language) {
        String content = Base64.encode((byte[])bytes, (int)0, (int)bytes.length, (boolean)false);
        StringBuilder sb = new StringBuilder(serverPath.length() + content.length() + 100);
        sb.append("udf-put:filename=");
        sb.append(serverPath);
        sb.append(";content=");
        sb.append(content);
        sb.append(";content-len=");
        sb.append(content.length());
        sb.append(";udf-type=");
        sb.append((Object)language);
        sb.append(";");
        String command = sb.toString();
        Node node = cluster.getRandomNode();
        Connection conn = node.getConnection(policy.socketTimeout);
        try {
            Info info = new Info(conn, command);
            Info.NameValueParser parser = info.getNameValueParser();
            String error = null;
            String file = null;
            String line = null;
            String message = null;
            while (parser.next()) {
                String name = parser.getName();
                if (name.equals("error")) {
                    error = parser.getValue();
                    continue;
                }
                if (name.equals("file")) {
                    file = parser.getValue();
                    continue;
                }
                if (name.equals("line")) {
                    line = parser.getValue();
                    continue;
                }
                if (!name.equals("message")) continue;
                message = parser.getStringBase64();
            }
            if (error != null) {
                throw new AerospikeException("Registration failed: " + error + Environment.Newline + "File: " + file + Environment.Newline + "Line: " + line + Environment.Newline + "Message: " + message);
            }
            node.putConnection(conn);
            return new RegisterTask(cluster, policy, serverPath);
        }
        catch (RuntimeException re) {
            node.closeConnection(conn);
            throw re;
        }
    }
}

