/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.task;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.task.Task;

public final class IndexTask
extends Task {
    private final String namespace;
    private final String indexName;

    public IndexTask(Cluster cluster, Policy policy, String namespace, String indexName) {
        super(cluster, policy);
        this.namespace = namespace;
        this.indexName = indexName;
    }

    public IndexTask() {
        this.namespace = null;
        this.indexName = null;
    }

    @Override
    public int queryStatus() throws AerospikeException {
        Node[] nodes = this.cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException("Cluster is empty");
        }
        String command = "sindex/" + this.namespace + '/' + this.indexName;
        for (Node node : nodes) {
            int end;
            String find;
            String response = Info.request(this.policy, node, command);
            int index2 = response.indexOf(find = "load_pct=");
            if (index2 < 0) {
                if (response.indexOf("FAIL:201") >= 0 || response.indexOf("FAIL:203") >= 0) {
                    return 0;
                }
                throw new AerospikeException(command + " failed: " + response);
            }
            int begin = index2 + find.length();
            String str = response.substring(begin, end = response.indexOf(59, begin));
            int pct = Integer.parseInt(str);
            if (pct == 100) continue;
            return 1;
        }
        return 2;
    }
}

