/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.BatchNodeList;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import java.util.List;

public final class AsyncBatch {

    private static abstract class AsyncBatchCommand
    extends AsyncMultiCommand {
        final BatchNode batch;
        final BatchPolicy batchPolicy;
        int sequenceAP;
        int sequenceSC;

        public AsyncBatchCommand(AsyncMultiExecutor parent, BatchNode batch, BatchPolicy batchPolicy, boolean isOperation) {
            super(parent, batch.node, batchPolicy, isOperation);
            this.batch = batch;
            this.batchPolicy = batchPolicy;
        }

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.parent.done || this.policy.replica != Replica.SEQUENCE && this.policy.replica != Replica.PREFER_RACK) {
                return true;
            }
            ++this.sequenceAP;
            if (!timeout || this.policy.readModeSC != ReadModeSC.LINEARIZE) {
                ++this.sequenceSC;
            }
            return false;
        }

        @Override
        protected boolean retryBatch(Runnable other, long deadline) {
            List<BatchNode> batchNodes = this.generateBatchNodes();
            if (batchNodes.size() == 0 || batchNodes.size() == 1 && batchNodes.get((int)0).node == this.batch.node) {
                return false;
            }
            AsyncMultiCommand[] cmds = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                AsyncBatchCommand cmd = this.createCommand(batchNode);
                cmd.sequenceAP = this.sequenceAP;
                cmd.sequenceSC = this.sequenceSC;
                cmds[count++] = cmd;
            }
            this.parent.executeBatchRetry(cmds, this, other, deadline);
            return true;
        }

        abstract AsyncBatchCommand createCommand(BatchNode var1);

        abstract List<BatchNode> generateBatchNodes();
    }

    private static final class ExistsSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final ExistsSequenceListener listener;

        public ExistsSequenceCommand(AsyncMultiExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, ExistsSequenceListener listener) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.listener = listener;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, null, 33);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            Key keyOrig = this.keys[this.batchIndex];
            this.listener.onExists(keyOrig, this.resultCode == 0);
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ExistsSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.listener);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            BatchNodeList bnl = new BatchNodeList(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false);
            this.parent.resetException(bnl.exception);
            return bnl.list;
        }
    }

    public static final class ExistsSequenceExecutor
    extends AsyncMultiExecutor {
        private final ExistsSequenceListener listener;

        public ExistsSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, Key[] keys, ExistsSequenceListener listener) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            BatchNodeList bnl = new BatchNodeList(cluster, policy, keys, false);
            bnl.validate();
            super.setException(bnl.exception);
            List<BatchNode> batchNodes = bnl.list;
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new ExistsSequenceCommand((AsyncMultiExecutor)this, batchNode, policy, keys, listener);
            }
            this.execute(tasks, 0);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ExistsArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(AsyncMultiExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, boolean[] existsArray) {
            super(parent, batch, batchPolicy, false);
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, null, 33);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            this.existsArray[this.batchIndex] = this.resultCode == 0;
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ExistsArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.existsArray);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }

    public static final class ExistsArrayExecutor
    extends AsyncMultiExecutor {
        private final ExistsArrayListener listener;
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, Key[] keys, ExistsArrayListener listener) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.keys = keys;
            this.existsArray = new boolean[keys.length];
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys);
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new ExistsArrayCommand((AsyncMultiExecutor)this, batchNode, policy, keys, this.existsArray);
            }
            this.execute(tasks, 0);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.keys, this.existsArray);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class GetSequenceCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Operation[] ops;
        private final RecordSequenceListener listener;
        private final int readAttr;

        public GetSequenceCommand(AsyncMultiExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String[] binNames, Operation[] ops, RecordSequenceListener listener, int readAttr, boolean isOperation) {
            super(parent, batch, batchPolicy, isOperation);
            this.keys = keys;
            this.binNames = binNames;
            this.ops = ops;
            this.listener = listener;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) {
            Key keyOrig = this.keys[this.batchIndex];
            if (this.resultCode == 0) {
                Record record = this.parseRecord();
                this.listener.onRecord(keyOrig, record);
            } else {
                this.listener.onRecord(keyOrig, null);
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new GetSequenceCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.binNames, this.ops, this.listener, this.readAttr, this.isOperation);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            BatchNodeList bnl = new BatchNodeList(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch, false);
            this.parent.resetException(bnl.exception);
            return bnl.list;
        }
    }

    public static final class GetSequenceExecutor
    extends AsyncMultiExecutor {
        private final RecordSequenceListener listener;

        public GetSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, RecordSequenceListener listener, Key[] keys, String[] binNames, Operation[] ops, int readAttr, boolean isOperation) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            BatchNodeList bnl = new BatchNodeList(cluster, policy, keys, false);
            bnl.validate();
            super.setException(bnl.exception);
            List<BatchNode> batchNodes = bnl.list;
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new GetSequenceCommand(this, batchNode, policy, keys, binNames, ops, listener, readAttr, isOperation);
            }
            this.execute(tasks, 0);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class GetArrayCommand
    extends AsyncBatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Operation[] ops;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(AsyncMultiExecutor parent, BatchNode batch, BatchPolicy batchPolicy, Key[] keys, String[] binNames, Operation[] ops, Record[] records, int readAttr, boolean isOperation) {
            super(parent, batch, batchPolicy, isOperation);
            this.keys = keys;
            this.binNames = binNames;
            this.ops = ops;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.ops, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.resultCode == 0) {
                this.records[this.batchIndex] = this.parseRecord();
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new GetArrayCommand(this.parent, batchNode, this.batchPolicy, this.keys, this.binNames, this.ops, this.records, this.readAttr, this.isOperation);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }

    public static final class GetArrayExecutor
    extends AsyncMultiExecutor {
        private final RecordArrayListener listener;
        private final Key[] keys;
        private final Record[] recordArray;

        public GetArrayExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, RecordArrayListener listener, Key[] keys, String[] binNames, Operation[] ops, int readAttr, boolean isOperation) {
            super(eventLoop, cluster, true);
            this.listener = listener;
            this.keys = keys;
            this.recordArray = new Record[keys.length];
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, keys);
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new GetArrayCommand(this, batchNode, policy, keys, binNames, ops, this.recordArray, readAttr, isOperation);
            }
            this.execute(tasks, 0);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.keys, this.recordArray);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ReadSequenceCommand
    extends AsyncBatchCommand {
        private final BatchSequenceListener listener;
        private final List<BatchRead> records;

        public ReadSequenceCommand(AsyncMultiExecutor parent, BatchNode batch, BatchPolicy batchPolicy, BatchSequenceListener listener, List<BatchRead> records) {
            super(parent, batch, batchPolicy, true);
            this.listener = listener;
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.records, this.batch);
        }

        @Override
        protected void parseRow(Key key) {
            BatchRead record = this.records.get(this.batchIndex);
            if (this.resultCode == 0) {
                record.record = this.parseRecord();
            }
            this.listener.onRecord(record);
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ReadSequenceCommand(this.parent, batchNode, this.batchPolicy, this.listener, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            BatchNodeList bnl = new BatchNodeList(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch, false);
            this.parent.resetException(bnl.exception);
            return bnl.list;
        }
    }

    public static final class ReadSequenceExecutor
    extends AsyncMultiExecutor {
        private final BatchSequenceListener listener;

        public ReadSequenceExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchSequenceListener listener, List<BatchRead> records) {
            super(eventLoop, cluster, false);
            this.listener = listener;
            BatchNodeList bnl = new BatchNodeList(cluster, policy, records, false);
            bnl.validate();
            super.setException(bnl.exception);
            List<BatchNode> batchNodes = bnl.list;
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new ReadSequenceCommand((AsyncMultiExecutor)this, batchNode, policy, listener, records);
            }
            this.execute(tasks, 0);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess();
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }

    private static final class ReadListCommand
    extends AsyncBatchCommand {
        private final List<BatchRead> records;

        public ReadListCommand(AsyncMultiExecutor parent, BatchNode batch, BatchPolicy batchPolicy, List<BatchRead> records) {
            super(parent, batch, batchPolicy, true);
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.records, this.batch);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.resultCode == 0) {
                BatchRead record = this.records.get(this.batchIndex);
                record.record = this.parseRecord();
            }
        }

        @Override
        protected AsyncBatchCommand createCommand(BatchNode batchNode) {
            return new ReadListCommand(this.parent, batchNode, this.batchPolicy, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNodeList.generate(this.parent.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }

    public static final class ReadListExecutor
    extends AsyncMultiExecutor {
        private final BatchListListener listener;
        private final List<BatchRead> records;

        public ReadListExecutor(EventLoop eventLoop, Cluster cluster, BatchPolicy policy, BatchListListener listener, List<BatchRead> records) {
            super(eventLoop, cluster);
            this.listener = listener;
            this.records = records;
            List<BatchNode> batchNodes = BatchNodeList.generate(cluster, policy, records);
            AsyncMultiCommand[] tasks = new AsyncMultiCommand[batchNodes.size()];
            int count = 0;
            for (BatchNode batchNode : batchNodes) {
                tasks[count++] = new ReadListCommand((AsyncMultiExecutor)this, batchNode, policy, records);
            }
            this.execute(tasks, 0);
        }

        @Override
        protected void onSuccess() {
            this.listener.onSuccess(this.records);
        }

        @Override
        protected void onFailure(AerospikeException ae) {
            this.listener.onFailure(ae);
        }
    }
}

