/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncConnector;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.Monitor;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.Util;
import java.util.concurrent.atomic.AtomicInteger;

public final class AsyncConnectorExecutor
implements AsyncConnector.Listener {
    private final Monitor monitor;
    private final AtomicInteger eventLoopCount;
    private final int maxConnections;
    private final int maxConcurrent;
    private int countConnections;
    private boolean done;

    public AsyncConnectorExecutor(EventLoop eventLoop, Cluster cluster, Node node, int maxConnections, int maxConcurrent, Monitor monitor, AtomicInteger eventLoopCount) {
        this.monitor = monitor;
        this.eventLoopCount = eventLoopCount;
        this.maxConnections = maxConnections;
        this.maxConcurrent = maxConnections >= maxConcurrent ? maxConcurrent : maxConnections;
        try {
            for (int i = 0; i < this.maxConcurrent; ++i) {
                AsyncConnector ac = eventLoop.createConnector(cluster, node, this);
                if (ac.execute()) continue;
                this.complete();
                break;
            }
        }
        catch (Exception e) {
            this.complete();
            throw e;
        }
    }

    @Override
    public void onSuccess(AsyncConnector ac) {
        ++this.countConnections;
        if (this.countConnections < this.maxConnections) {
            int next = this.countConnections + this.maxConcurrent - 1;
            if (next < this.maxConnections && !this.done && !ac.execute()) {
                this.complete();
            }
        } else {
            this.complete();
        }
    }

    @Override
    public void onFailure(AerospikeException e) {
        if (Log.warnEnabled()) {
            Log.warn("Async min connections failed: " + Util.getErrorMessage(e));
        }
        this.complete();
    }

    @Override
    public void onFailure() {
        this.complete();
    }

    private void complete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.monitor != null) {
            AsyncConnectorExecutor.eventLoopComplete(this.monitor, this.eventLoopCount);
        }
    }

    public static void eventLoopComplete(Monitor monitor, AtomicInteger eventLoopCount) {
        int count = eventLoopCount.decrementAndGet();
        if (count == 0) {
            monitor.notifyComplete();
        }
    }
}

