/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Replica;
import java.util.ArrayList;
import java.util.List;

public final class BatchNodeList {
    public final List<BatchNode> list;
    public final AerospikeException exception;

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, Key[] keys) {
        BatchNodeList bnl = new BatchNodeList(cluster, policy, keys, true);
        return bnl.list;
    }

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, Key[] keys, int sequenceAP, int sequenceSC, BatchNode batchSeed) {
        BatchNodeList bnl = new BatchNodeList(cluster, policy, keys, sequenceAP, sequenceSC, batchSeed, true);
        return bnl.list;
    }

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, List<BatchRead> records) {
        BatchNodeList bnl = new BatchNodeList(cluster, policy, records, true);
        return bnl.list;
    }

    public static List<BatchNode> generate(Cluster cluster, BatchPolicy policy, List<BatchRead> records, int sequenceAP, int sequenceSC, BatchNode batchSeed) {
        BatchNodeList bnl = new BatchNodeList(cluster, policy, records, sequenceAP, sequenceSC, batchSeed, true);
        return bnl.list;
    }

    public BatchNodeList(Cluster cluster, BatchPolicy policy, Key[] keys, boolean stopOnInvalidNode) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = keys.length / nodes.length;
        keysPerNode += keysPerNode >>> 2;
        if (keysPerNode < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException.InvalidNode except = null;
        for (int i = 0; i < keys.length; ++i) {
            try {
                Node node = Partition.getNodeBatchRead(cluster, keys[i], replica, replicaSC, null, 0, 0);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, i));
                    continue;
                }
                batchNode.addKey(i);
                continue;
            }
            catch (AerospikeException.InvalidNode ain) {
                if (stopOnInvalidNode) {
                    throw ain;
                }
                if (except != null) continue;
                except = ain;
            }
        }
        this.list = batchNodes;
        this.exception = except;
    }

    public BatchNodeList(Cluster cluster, BatchPolicy policy, Key[] keys, int sequenceAP, int sequenceSC, BatchNode batchSeed, boolean stopOnInvalidNode) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = batchSeed.offsetsSize / nodes.length;
        keysPerNode += keysPerNode >>> 2;
        if (keysPerNode < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException.InvalidNode except = null;
        for (int i = 0; i < batchSeed.offsetsSize; ++i) {
            int offset = batchSeed.offsets[i];
            try {
                Node node = Partition.getNodeBatchRead(cluster, keys[offset], replica, replicaSC, batchSeed.node, sequenceAP, sequenceSC);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, offset));
                    continue;
                }
                batchNode.addKey(offset);
                continue;
            }
            catch (AerospikeException.InvalidNode ain) {
                if (stopOnInvalidNode) {
                    throw ain;
                }
                if (except != null) continue;
                except = ain;
            }
        }
        this.list = batchNodes;
        this.exception = except;
    }

    public BatchNodeList(Cluster cluster, BatchPolicy policy, List<BatchRead> records, boolean stopOnInvalidNode) {
        Node[] nodes = cluster.validateNodes();
        int max = records.size();
        int keysPerNode = max / nodes.length;
        keysPerNode += keysPerNode >>> 2;
        if (keysPerNode < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException.InvalidNode except = null;
        for (int i = 0; i < max; ++i) {
            try {
                Node node = Partition.getNodeBatchRead(cluster, records.get((int)i).key, replica, replicaSC, null, 0, 0);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, i));
                    continue;
                }
                batchNode.addKey(i);
                continue;
            }
            catch (AerospikeException.InvalidNode ain) {
                if (stopOnInvalidNode) {
                    throw ain;
                }
                if (except != null) continue;
                except = ain;
            }
        }
        this.list = batchNodes;
        this.exception = except;
    }

    public BatchNodeList(Cluster cluster, BatchPolicy policy, List<BatchRead> records, int sequenceAP, int sequenceSC, BatchNode batchSeed, boolean stopOnInvalidNode) {
        Node[] nodes = cluster.validateNodes();
        int keysPerNode = batchSeed.offsetsSize / nodes.length;
        keysPerNode += keysPerNode >>> 2;
        if (keysPerNode < 10) {
            keysPerNode = 10;
        }
        Replica replica = policy.replica;
        Replica replicaSC = Partition.getReplicaSC(policy);
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        AerospikeException.InvalidNode except = null;
        for (int i = 0; i < batchSeed.offsetsSize; ++i) {
            int offset = batchSeed.offsets[i];
            try {
                Node node = Partition.getNodeBatchRead(cluster, records.get((int)offset).key, replica, replicaSC, batchSeed.node, sequenceAP, sequenceSC);
                BatchNode batchNode = BatchNodeList.findBatchNode(batchNodes, node);
                if (batchNode == null) {
                    batchNodes.add(new BatchNode(node, keysPerNode, offset));
                    continue;
                }
                batchNode.addKey(offset);
                continue;
            }
            catch (AerospikeException.InvalidNode ain) {
                if (stopOnInvalidNode) {
                    throw ain;
                }
                if (except != null) continue;
                except = ain;
            }
        }
        this.list = batchNodes;
        this.exception = except;
    }

    public void validate() {
        if (this.exception != null && this.list.size() == 0) {
            throw this.exception;
        }
    }

    private static BatchNode findBatchNode(List<BatchNode> nodes, Node node) {
        for (BatchNode batchNode : nodes) {
            if (batchNode.node != node) continue;
            return batchNode;
        }
        return null;
    }
}

