/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.Bin;
import com.aerospike.client.Value;

public final class Operation {
    public final Type type;
    public final String binName;
    public final Value value;

    public static Operation get(String binName) {
        return new Operation(Type.READ, binName);
    }

    public static Operation get() {
        return new Operation(Type.READ);
    }

    public static Operation getHeader() {
        return new Operation(Type.READ_HEADER);
    }

    public static Operation put(Bin bin) {
        return new Operation(Type.WRITE, bin.name, bin.value);
    }

    public static Operation append(Bin bin) {
        return new Operation(Type.APPEND, bin.name, bin.value);
    }

    public static Operation prepend(Bin bin) {
        return new Operation(Type.PREPEND, bin.name, bin.value);
    }

    public static Operation add(Bin bin) {
        return new Operation(Type.ADD, bin.name, bin.value);
    }

    public static Operation touch() {
        return new Operation(Type.TOUCH);
    }

    public static Operation delete() {
        return new Operation(Type.DELETE);
    }

    public static Operation[] array(Operation ... ops) {
        return ops;
    }

    public Operation(Type type, String binName, Value value) {
        this.type = type;
        this.binName = binName;
        this.value = value;
    }

    private Operation(Type type, String binName) {
        this.type = type;
        this.binName = binName;
        this.value = Value.getAsNull();
    }

    private Operation(Type type) {
        this.type = type;
        this.binName = null;
        this.value = Value.getAsNull();
    }

    public static enum Type {
        READ(1, false),
        READ_HEADER(1, false),
        WRITE(2, true),
        CDT_READ(3, false),
        CDT_MODIFY(4, true),
        MAP_READ(3, false),
        MAP_MODIFY(4, true),
        ADD(5, true),
        EXP_READ(7, false),
        EXP_MODIFY(8, true),
        APPEND(9, true),
        PREPEND(10, true),
        TOUCH(11, true),
        BIT_READ(12, false),
        BIT_MODIFY(13, true),
        DELETE(14, true),
        HLL_READ(15, false),
        HLL_MODIFY(16, true);

        public final int protocolType;
        public final boolean isWrite;

        private Type(int protocolType, boolean isWrite) {
            this.protocolType = protocolType;
            this.isWrite = isWrite;
        }
    }
}

