/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncQueryPartition;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.RandomShift;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class AsyncQueryPartitionExecutor
extends AsyncMultiExecutor {
    private final QueryPolicy policy;
    private final RecordSequenceListener listener;
    private final Statement statement;
    private final PartitionTracker tracker;
    private long taskId;

    public AsyncQueryPartitionExecutor(EventLoop eventLoop, RecordSequenceListener listener, Cluster cluster, QueryPolicy policy, Statement statement, PartitionTracker tracker) {
        super(eventLoop, cluster);
        this.policy = policy;
        this.listener = listener;
        this.statement = statement;
        this.tracker = tracker;
        this.taskId = statement.prepareTaskId();
        tracker.setSleepBetweenRetries(0);
        this.queryPartitions();
    }

    private void queryPartitions() {
        List<PartitionTracker.NodePartitions> nodePartitionsList = this.tracker.assignPartitionsToNodes(this.cluster, this.statement.getNamespace());
        AsyncMultiCommand[] tasks = new AsyncQueryPartition[nodePartitionsList.size()];
        int count = 0;
        for (PartitionTracker.NodePartitions nodePartitions : nodePartitionsList) {
            tasks[count++] = new AsyncQueryPartition(this, this.policy, this.listener, this.statement, this.taskId, this.tracker, nodePartitions);
        }
        this.execute(tasks, this.policy.maxConcurrentNodes);
    }

    @Override
    protected void onSuccess() {
        try {
            if (this.tracker.isComplete(this.cluster, this.policy)) {
                this.listener.onSuccess();
                return;
            }
            if (this.policy.sleepBetweenRetries > 0) {
                this.eventLoop.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AsyncQueryPartitionExecutor.this.reset();
                            AsyncQueryPartitionExecutor.this.taskId = RandomShift.instance().nextLong();
                            AsyncQueryPartitionExecutor.this.queryPartitions();
                        }
                        catch (AerospikeException ae) {
                            AsyncQueryPartitionExecutor.this.onFailure(ae);
                        }
                        catch (Exception e) {
                            AsyncQueryPartitionExecutor.this.onFailure(new AerospikeException(e));
                        }
                    }
                }, (long)this.policy.sleepBetweenRetries, TimeUnit.MILLISECONDS);
            } else {
                this.reset();
                this.taskId = RandomShift.instance().nextLong();
                this.queryPartitions();
            }
        }
        catch (AerospikeException ae) {
            this.onFailure(ae);
        }
        catch (Exception e) {
            this.onFailure(new AerospikeException(e));
        }
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        this.tracker.partitionError();
        ae.setIteration(this.tracker.iteration);
        this.listener.onFailure(ae);
    }
}

