/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.exp;

import com.aerospike.client.cdt.CTX;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.operation.BitOverflowAction;
import com.aerospike.client.operation.BitPolicy;
import com.aerospike.client.util.Pack;
import com.aerospike.client.util.Packer;

public final class BitExp {
    private static final int MODULE = 1;
    private static final int RESIZE = 0;
    private static final int INSERT = 1;
    private static final int REMOVE = 2;
    private static final int SET = 3;
    private static final int OR = 4;
    private static final int XOR = 5;
    private static final int AND = 6;
    private static final int NOT = 7;
    private static final int LSHIFT = 8;
    private static final int RSHIFT = 9;
    private static final int ADD = 10;
    private static final int SUBTRACT = 11;
    private static final int SET_INT = 12;
    private static final int GET = 50;
    private static final int COUNT = 51;
    private static final int LSCAN = 52;
    private static final int RSCAN = 53;
    private static final int GET_INT = 54;
    private static final int INT_FLAGS_SIGNED = 1;

    public static Exp resize(BitPolicy policy, Exp byteSize, int resizeFlags, Exp bin) {
        byte[] bytes = Pack.pack(0, byteSize, policy.flags, resizeFlags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp insert(BitPolicy policy, Exp byteOffset, Exp value, Exp bin) {
        byte[] bytes = Pack.pack(1, byteOffset, value, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp remove(BitPolicy policy, Exp byteOffset, Exp byteSize, Exp bin) {
        byte[] bytes = Pack.pack(2, byteOffset, byteSize, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp set(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp value, Exp bin) {
        byte[] bytes = Pack.pack(3, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp or(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp value, Exp bin) {
        byte[] bytes = Pack.pack(4, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp xor(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp value, Exp bin) {
        byte[] bytes = Pack.pack(5, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp and(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp value, Exp bin) {
        byte[] bytes = Pack.pack(6, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp not(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp bin) {
        byte[] bytes = Pack.pack(7, bitOffset, bitSize, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp lshift(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp shift, Exp bin) {
        byte[] bytes = Pack.pack(8, bitOffset, bitSize, shift, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp rshift(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp shift, Exp bin) {
        byte[] bytes = Pack.pack(9, bitOffset, bitSize, shift, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp add(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp value, boolean signed, BitOverflowAction action, Exp bin) {
        byte[] bytes = BitExp.packMath(10, policy, bitOffset, bitSize, value, signed, action);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp subtract(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp value, boolean signed, BitOverflowAction action, Exp bin) {
        byte[] bytes = BitExp.packMath(11, policy, bitOffset, bitSize, value, signed, action);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp setInt(BitPolicy policy, Exp bitOffset, Exp bitSize, Exp value, Exp bin) {
        byte[] bytes = Pack.pack(12, bitOffset, bitSize, value, policy.flags, new CTX[0]);
        return BitExp.addWrite(bin, bytes);
    }

    public static Exp get(Exp bitOffset, Exp bitSize, Exp bin) {
        byte[] bytes = Pack.pack(50, bitOffset, bitSize, new CTX[0]);
        return BitExp.addRead(bin, bytes, Exp.Type.BLOB);
    }

    public static Exp count(Exp bitOffset, Exp bitSize, Exp bin) {
        byte[] bytes = Pack.pack(51, bitOffset, bitSize, new CTX[0]);
        return BitExp.addRead(bin, bytes, Exp.Type.INT);
    }

    public static Exp lscan(Exp bitOffset, Exp bitSize, Exp value, Exp bin) {
        byte[] bytes = Pack.pack(52, bitOffset, bitSize, value, new CTX[0]);
        return BitExp.addRead(bin, bytes, Exp.Type.INT);
    }

    public static Exp rscan(Exp bitOffset, Exp bitSize, Exp value, Exp bin) {
        byte[] bytes = Pack.pack(53, bitOffset, bitSize, value, new CTX[0]);
        return BitExp.addRead(bin, bytes, Exp.Type.INT);
    }

    public static Exp getInt(Exp bitOffset, Exp bitSize, boolean signed, Exp bin) {
        byte[] bytes = BitExp.packGetInt(bitOffset, bitSize, signed);
        return BitExp.addRead(bin, bytes, Exp.Type.INT);
    }

    private static byte[] packMath(int command, BitPolicy policy, Exp bitOffset, Exp bitSize, Exp value, boolean signed, BitOverflowAction action) {
        Packer packer = new Packer();
        packer.packArrayBegin(6);
        packer.packInt(command);
        bitOffset.pack(packer);
        bitSize.pack(packer);
        value.pack(packer);
        packer.packInt(policy.flags);
        int flags = action.flags;
        if (signed) {
            flags |= 1;
        }
        packer.packInt(flags);
        return packer.toByteArray();
    }

    private static byte[] packGetInt(Exp bitOffset, Exp bitSize, boolean signed) {
        Packer packer = new Packer();
        packer.packArrayBegin(signed ? 4 : 3);
        packer.packInt(54);
        bitOffset.pack(packer);
        bitSize.pack(packer);
        if (signed) {
            packer.packInt(1);
        }
        return packer.toByteArray();
    }

    private static Exp addWrite(Exp bin, byte[] bytes) {
        return new Exp.Module(bin, bytes, Exp.Type.BLOB.code, 65);
    }

    private static Exp addRead(Exp bin, byte[] bytes, Exp.Type retType) {
        return new Exp.Module(bin, bytes, retType.code, 1);
    }
}

