/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Typeface;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import com.airbnb.lottie.FontAssetDelegate;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.TextDelegate;
import com.airbnb.lottie.manager.FontAssetManager;
import com.airbnb.lottie.manager.ImageAssetManager;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.layer.CompositionLayer;
import com.airbnb.lottie.parser.LayerParser;
import com.airbnb.lottie.utils.LottieValueAnimator;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;
import com.airbnb.lottie.value.SimpleLottieValueCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LottieDrawable
extends Drawable
implements Drawable.Callback,
Animatable {
    private static final String TAG = LottieDrawable.class.getSimpleName();
    private final Matrix matrix = new Matrix();
    private LottieComposition composition;
    private final LottieValueAnimator animator = new LottieValueAnimator();
    private float scale = 1.0f;
    private final Set<ColorFilterData> colorFilterData = new HashSet<ColorFilterData>();
    private final ArrayList<LazyCompositionTask> lazyCompositionTasks = new ArrayList();
    @Nullable
    private ImageAssetManager imageAssetManager;
    @Nullable
    private String imageAssetsFolder;
    @Nullable
    private ImageAssetDelegate imageAssetDelegate;
    @Nullable
    private FontAssetManager fontAssetManager;
    @Nullable
    FontAssetDelegate fontAssetDelegate;
    @Nullable
    TextDelegate textDelegate;
    private boolean enableMergePaths;
    @Nullable
    private CompositionLayer compositionLayer;
    private int alpha = 255;
    private boolean performanceTrackingEnabled;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public LottieDrawable() {
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (LottieDrawable.this.compositionLayer != null) {
                    LottieDrawable.this.compositionLayer.setProgress(LottieDrawable.this.animator.getAnimatedValueAbsolute());
                }
            }
        });
    }

    public boolean hasMasks() {
        return this.compositionLayer != null && this.compositionLayer.hasMasks();
    }

    public boolean hasMatte() {
        return this.compositionLayer != null && this.compositionLayer.hasMatte();
    }

    public boolean enableMergePathsForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void enableMergePathsForKitKatAndAbove(boolean enable) {
        if (Build.VERSION.SDK_INT < 19) {
            Log.w((String)TAG, (String)"Merge paths are not supported pre-Kit Kat.");
            return;
        }
        this.enableMergePaths = enable;
        if (this.composition != null) {
            this.buildCompositionLayer();
        }
    }

    public boolean isMergePathsEnabledForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void setImagesAssetsFolder(@Nullable String imageAssetsFolder) {
        this.imageAssetsFolder = imageAssetsFolder;
    }

    @Nullable
    public String getImageAssetsFolder() {
        return this.imageAssetsFolder;
    }

    public void recycleBitmaps() {
        if (this.imageAssetManager != null) {
            this.imageAssetManager.recycleBitmaps();
        }
    }

    public boolean setComposition(LottieComposition composition) {
        if (this.composition == composition) {
            return false;
        }
        this.clearComposition();
        this.composition = composition;
        this.buildCompositionLayer();
        this.animator.setComposition(composition);
        this.setProgress(this.animator.getAnimatedFraction());
        this.setScale(this.scale);
        this.updateBounds();
        Iterator<LazyCompositionTask> it = new ArrayList<LazyCompositionTask>(this.lazyCompositionTasks).iterator();
        while (it.hasNext()) {
            LazyCompositionTask t = it.next();
            t.run(composition);
            it.remove();
        }
        this.lazyCompositionTasks.clear();
        composition.setPerformanceTrackingEnabled(this.performanceTrackingEnabled);
        return true;
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTrackingEnabled = enabled;
        if (this.composition != null) {
            this.composition.setPerformanceTrackingEnabled(enabled);
        }
    }

    @Nullable
    public PerformanceTracker getPerformanceTracker() {
        if (this.composition != null) {
            return this.composition.getPerformanceTracker();
        }
        return null;
    }

    private void buildCompositionLayer() {
        this.compositionLayer = new CompositionLayer(this, LayerParser.parse(this.composition), this.composition.getLayers(), this.composition);
    }

    public void clearComposition() {
        this.recycleBitmaps();
        if (this.animator.isRunning()) {
            this.animator.cancel();
        }
        this.composition = null;
        this.compositionLayer = null;
        this.imageAssetManager = null;
        this.animator.clearComposition();
        this.invalidateSelf();
    }

    public void invalidateSelf() {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Log.w((String)"LOTTIE", (String)"Use addColorFilter instead.");
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NonNull Canvas canvas) {
        L.beginSection("Drawable#draw");
        if (this.compositionLayer == null) {
            return;
        }
        float scale = this.scale;
        float extraScale = 1.0f;
        float maxScale = this.getMaxScale(canvas);
        if (scale > maxScale) {
            scale = maxScale;
            extraScale = this.scale / scale;
        }
        if (extraScale > 1.0f) {
            canvas.save();
            float halfWidth = (float)this.composition.getBounds().width() / 2.0f;
            float halfHeight = (float)this.composition.getBounds().height() / 2.0f;
            float scaledHalfWidth = halfWidth * scale;
            float scaledHalfHeight = halfHeight * scale;
            canvas.translate(this.getScale() * halfWidth - scaledHalfWidth, this.getScale() * halfHeight - scaledHalfHeight);
            canvas.scale(extraScale, extraScale, scaledHalfWidth, scaledHalfHeight);
        }
        this.matrix.reset();
        this.matrix.preScale(scale, scale);
        this.compositionLayer.draw(canvas, this.matrix, this.alpha);
        L.endSection("Drawable#draw");
        if (extraScale > 1.0f) {
            canvas.restore();
        }
    }

    public void start() {
        this.playAnimation();
    }

    public void stop() {
        this.endAnimation();
    }

    public boolean isRunning() {
        return this.isAnimating();
    }

    public void playAnimation() {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(c -> this.playAnimation());
            return;
        }
        this.animator.playAnimation();
    }

    public void endAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.endAnimation();
    }

    public void resumeAnimation() {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(c -> this.resumeAnimation());
            return;
        }
        this.animator.resumeAnimation();
    }

    public void setMinFrame(int minFrame) {
        this.animator.setMinFrame(minFrame);
    }

    public float getMinFrame() {
        return this.animator.getMinFrame();
    }

    public void setMinProgress(float minProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinProgress(minProgress));
            return;
        }
        this.setMinFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), minProgress));
    }

    public void setMaxFrame(int maxFrame) {
        this.animator.setMaxFrame(maxFrame);
    }

    public float getMaxFrame() {
        return this.animator.getMaxFrame();
    }

    public void setMaxProgress(@FloatRange(from=0.0, to=1.0) float maxProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMaxProgress(maxProgress));
            return;
        }
        this.setMaxFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), maxProgress));
    }

    public void setMinAndMaxFrame(int minFrame, int maxFrame) {
        this.animator.setMinAndMaxFrames(minFrame, maxFrame);
    }

    public void setMinAndMaxProgress(@FloatRange(from=0.0, to=1.0) float minProgress, @FloatRange(from=0.0, to=1.0) float maxProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinAndMaxProgress(minProgress, maxProgress));
            return;
        }
        this.setMinAndMaxFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), minProgress), (int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), maxProgress));
    }

    public void reverseAnimationSpeed() {
        this.animator.reverseAnimationSpeed();
    }

    public void setSpeed(float speed) {
        this.animator.setSpeed(speed);
    }

    public float getSpeed() {
        return this.animator.getSpeed();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.addUpdateListener(updateListener);
    }

    public void removeAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.removeUpdateListener(updateListener);
    }

    public void removeAllUpdateListeners() {
        this.animator.removeAllUpdateListeners();
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.addListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.removeListener(listener);
    }

    public void removeAllAnimatorListeners() {
        this.animator.removeAllListeners();
    }

    public void setFrame(int frame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setFrame(frame));
            return;
        }
        this.animator.setFrame(frame);
    }

    public int getFrame() {
        return (int)this.animator.getFrame();
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setProgress(progress));
            return;
        }
        this.setFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), progress));
    }

    @Deprecated
    public void loop(boolean loop) {
        this.animator.setRepeatCount(loop ? -1 : 0);
    }

    public void setRepeatMode(int mode) {
        this.animator.setRepeatMode(mode);
    }

    public int getRepeatMode() {
        return this.animator.getRepeatMode();
    }

    public void setRepeatCount(int count) {
        this.animator.setRepeatCount(count);
    }

    public int getRepeatCount() {
        return this.animator.getRepeatCount();
    }

    public boolean isLooping() {
        return this.animator.getRepeatCount() == -1;
    }

    public boolean isAnimating() {
        return this.animator.isRunning();
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.updateBounds();
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.imageAssetDelegate = assetDelegate;
        if (this.imageAssetManager != null) {
            this.imageAssetManager.setDelegate(assetDelegate);
        }
    }

    public void setFontAssetDelegate(FontAssetDelegate assetDelegate) {
        this.fontAssetDelegate = assetDelegate;
        if (this.fontAssetManager != null) {
            this.fontAssetManager.setDelegate(assetDelegate);
        }
    }

    public void setTextDelegate(TextDelegate textDelegate) {
        this.textDelegate = textDelegate;
    }

    @Nullable
    public TextDelegate getTextDelegate() {
        return this.textDelegate;
    }

    public boolean useTextGlyphs() {
        return this.textDelegate == null && this.composition.getCharacters().size() > 0;
    }

    public float getScale() {
        return this.scale;
    }

    public LottieComposition getComposition() {
        return this.composition;
    }

    private void updateBounds() {
        if (this.composition == null) {
            return;
        }
        float scale = this.getScale();
        this.setBounds(0, 0, (int)((float)this.composition.getBounds().width() * scale), (int)((float)this.composition.getBounds().height() * scale));
    }

    public void cancelAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.cancel();
    }

    public void pauseAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.pauseAnimation();
    }

    @FloatRange(from=0.0, to=1.0)
    public float getProgress() {
        return this.animator.getAnimatedValueAbsolute();
    }

    public int getIntrinsicWidth() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().width() * this.getScale());
    }

    public int getIntrinsicHeight() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().height() * this.getScale());
    }

    public List<KeyPath> resolveKeyPath(KeyPath keyPath) {
        if (this.compositionLayer == null) {
            Log.w((String)"LOTTIE", (String)"Cannot resolve KeyPath. Composition is not set yet.");
            return Collections.emptyList();
        }
        ArrayList<KeyPath> keyPaths = new ArrayList<KeyPath>();
        this.compositionLayer.resolveKeyPath(keyPath, 0, keyPaths, new KeyPath(new String[0]));
        return keyPaths;
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, LottieValueCallback<T> callback) {
        boolean invalidate;
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(c -> this.addValueCallback(keyPath, property, callback));
            return;
        }
        if (keyPath.getResolvedElement() != null) {
            keyPath.getResolvedElement().addValueCallback(property, callback);
            invalidate = true;
        } else {
            List<KeyPath> elements = this.resolveKeyPath(keyPath);
            for (int i = 0; i < elements.size(); ++i) {
                elements.get(i).getResolvedElement().addValueCallback(property, callback);
            }
            boolean bl = invalidate = !elements.isEmpty();
        }
        if (invalidate) {
            this.invalidateSelf();
            if (property == LottieProperty.TIME_REMAP) {
                this.setProgress(this.getProgress());
            }
        }
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, final SimpleLottieValueCallback<T> callback) {
        this.addValueCallback(keyPath, property, new LottieValueCallback<T>(){

            @Override
            public T getValue(LottieFrameInfo<T> frameInfo) {
                return callback.getValue(frameInfo);
            }
        });
    }

    @Nullable
    public Bitmap updateBitmap(String id, @Nullable Bitmap bitmap) {
        ImageAssetManager bm = this.getImageAssetManager();
        if (bm == null) {
            Log.w((String)"LOTTIE", (String)"Cannot update bitmap. Most likely the drawable is not added to a View which prevents Lottie from getting a Context.");
            return null;
        }
        Bitmap ret = bm.updateBitmap(id, bitmap);
        this.invalidateSelf();
        return ret;
    }

    @Nullable
    public Bitmap getImageAsset(String id) {
        ImageAssetManager bm = this.getImageAssetManager();
        if (bm != null) {
            return bm.bitmapForId(id);
        }
        return null;
    }

    private ImageAssetManager getImageAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.imageAssetManager != null && !this.imageAssetManager.hasSameContext(this.getContext())) {
            this.imageAssetManager.recycleBitmaps();
            this.imageAssetManager = null;
        }
        if (this.imageAssetManager == null) {
            this.imageAssetManager = new ImageAssetManager(this.getCallback(), this.imageAssetsFolder, this.imageAssetDelegate, this.composition.getImages());
        }
        return this.imageAssetManager;
    }

    @Nullable
    public Typeface getTypeface(String fontFamily, String style) {
        FontAssetManager assetManager = this.getFontAssetManager();
        if (assetManager != null) {
            return assetManager.getTypeface(fontFamily, style);
        }
        return null;
    }

    private FontAssetManager getFontAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.fontAssetManager == null) {
            this.fontAssetManager = new FontAssetManager(this.getCallback(), this.fontAssetDelegate);
        }
        return this.fontAssetManager;
    }

    @Nullable
    private Context getContext() {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return null;
        }
        if (callback instanceof View) {
            return ((View)callback).getContext();
        }
        return null;
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.invalidateDrawable((Drawable)this);
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.scheduleDrawable((Drawable)this, what, when);
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.unscheduleDrawable((Drawable)this, what);
    }

    private float getMaxScale(@NonNull Canvas canvas) {
        float maxScaleX = (float)canvas.getWidth() / (float)this.composition.getBounds().width();
        float maxScaleY = (float)canvas.getHeight() / (float)this.composition.getBounds().height();
        return Math.min(maxScaleX, maxScaleY);
    }

    private static class ColorFilterData {
        final String layerName;
        @Nullable
        final String contentName;
        @Nullable
        final ColorFilter colorFilter;

        ColorFilterData(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
            this.layerName = layerName;
            this.contentName = contentName;
            this.colorFilter = colorFilter;
        }

        public int hashCode() {
            int hashCode = 17;
            if (this.layerName != null) {
                hashCode = hashCode * 31 * this.layerName.hashCode();
            }
            if (this.contentName != null) {
                hashCode = hashCode * 31 * this.contentName.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ColorFilterData)) {
                return false;
            }
            ColorFilterData other = (ColorFilterData)obj;
            return this.hashCode() == other.hashCode() && this.colorFilter == other.colorFilter;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RepeatMode {
    }

    private static interface LazyCompositionTask {
        public void run(LottieComposition var1);
    }
}

