/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.support.annotation.CheckResult;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.airbnb.lottie.model.KeyPathElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KeyPath {
    private final List<String> keys;
    @Nullable
    private KeyPathElement resolvedElement;

    public KeyPath(String ... keys) {
        this.keys = Arrays.asList(keys);
    }

    private KeyPath(KeyPath keyPath) {
        this.keys = new ArrayList<String>(keyPath.keys);
        this.resolvedElement = keyPath.resolvedElement;
    }

    @CheckResult
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public KeyPath addKey(String key) {
        KeyPath newKeyPath = new KeyPath(this);
        newKeyPath.keys.add(key);
        return newKeyPath;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public KeyPath resolve(KeyPathElement element) {
        KeyPath keyPath = new KeyPath(this);
        keyPath.resolvedElement = element;
        return keyPath;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public KeyPathElement getResolvedElement() {
        return this.resolvedElement;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean matches(String key, int depth) {
        if (this.isContainer(key)) {
            return true;
        }
        if (depth >= this.keys.size()) {
            return false;
        }
        return this.keys.get(depth).equals(key) || this.keys.get(depth).equals("**") || this.keys.get(depth).equals("*");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int incrementDepthBy(String key, int depth) {
        if (this.isContainer(key)) {
            return 0;
        }
        if (!this.keys.get(depth).equals("**")) {
            return 1;
        }
        if (depth == this.keys.size() - 1) {
            return 0;
        }
        if (this.keys.get(depth + 1).equals(key)) {
            return 2;
        }
        return 0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean fullyResolvesTo(String key, int depth) {
        boolean isGlobstarButNextKeyMatches;
        if (depth >= this.keys.size()) {
            return false;
        }
        boolean isLastDepth = depth == this.keys.size() - 1;
        String keyAtDepth = this.keys.get(depth);
        boolean isGlobstar = keyAtDepth.equals("**");
        if (!isGlobstar) {
            boolean matches = keyAtDepth.equals(key) || keyAtDepth.equals("*");
            return (isLastDepth || depth == this.keys.size() - 2 && this.endsWithGlobstar()) && matches;
        }
        boolean bl = isGlobstarButNextKeyMatches = !isLastDepth && this.keys.get(depth + 1).equals(key);
        if (isGlobstarButNextKeyMatches) {
            return depth == this.keys.size() - 2 || depth == this.keys.size() - 3 && this.endsWithGlobstar();
        }
        if (isLastDepth) {
            return true;
        }
        if (depth + 1 < this.keys.size() - 1) {
            return false;
        }
        return this.keys.get(depth + 1).equals(key);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean propagateToChildren(String key, int depth) {
        if (key.equals("__container")) {
            return true;
        }
        return depth < this.keys.size() - 1 || this.keys.get(depth).equals("**");
    }

    private boolean isContainer(String key) {
        return key.equals("__container");
    }

    private boolean endsWithGlobstar() {
        return this.keys.get(this.keys.size() - 1).equals("**");
    }

    public String keysToString() {
        return this.keys.toString();
    }

    public String toString() {
        return "KeyPath{keys=" + this.keys + ",resolved=" + (this.resolvedElement != null) + '}';
    }
}

