/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.model.layer.ShapeLayer;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.List;

public class CompositionLayer
extends BaseLayer {
    @Nullable
    private BaseKeyframeAnimation<Float, Float> timeRemapping;
    private final List<BaseLayer> layers = new ArrayList<BaseLayer>();
    private final RectF rect = new RectF();
    private final RectF newClipRect = new RectF();
    @Nullable
    private Boolean hasMatte;
    @Nullable
    private Boolean hasMasks;

    public CompositionLayer(LottieDrawable lottieDrawable, Layer layerModel, List<Layer> layerModels, LottieComposition composition) {
        super(lottieDrawable, layerModel);
        int i;
        AnimatableFloatValue timeRemapping = layerModel.getTimeRemapping();
        if (timeRemapping != null) {
            this.timeRemapping = timeRemapping.createAnimation();
            this.addAnimation(this.timeRemapping);
            this.timeRemapping.addUpdateListener(this);
        } else {
            this.timeRemapping = null;
        }
        LongSparseArray layerMap = new LongSparseArray(composition.getLayers().size());
        BaseLayer mattedLayer = null;
        for (i = layerModels.size() - 1; i >= 0; --i) {
            Layer lm = layerModels.get(i);
            BaseLayer layer = BaseLayer.forModel(lm, lottieDrawable, composition);
            if (layer == null) continue;
            layerMap.put(layer.getLayerModel().getId(), (Object)layer);
            if (mattedLayer != null) {
                mattedLayer.setMatteLayer(layer);
                mattedLayer = null;
                continue;
            }
            this.layers.add(0, layer);
            switch (lm.getMatteType()) {
                case Add: 
                case Invert: {
                    mattedLayer = layer;
                }
            }
        }
        for (i = 0; i < layerMap.size(); ++i) {
            BaseLayer parentLayer;
            long key = layerMap.keyAt(i);
            BaseLayer layerView = (BaseLayer)layerMap.get(key);
            if (layerView == null || (parentLayer = (BaseLayer)layerMap.get(layerView.getLayerModel().getParentId())) == null) continue;
            layerView.setParentLayer(parentLayer);
        }
    }

    @Override
    void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        L.beginSection("CompositionLayer#draw");
        canvas.save();
        this.newClipRect.set(0.0f, 0.0f, (float)this.layerModel.getPreCompWidth(), (float)this.layerModel.getPreCompHeight());
        parentMatrix.mapRect(this.newClipRect);
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            boolean nonEmptyClip = true;
            if (!this.newClipRect.isEmpty()) {
                nonEmptyClip = canvas.clipRect(this.newClipRect);
            }
            if (!nonEmptyClip) continue;
            BaseLayer layer = this.layers.get(i);
            layer.draw(canvas, parentMatrix, parentAlpha);
        }
        canvas.restore();
        L.endSection("CompositionLayer#draw");
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        super.getBounds(outBounds, parentMatrix);
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            BaseLayer content = this.layers.get(i);
            content.getBounds(this.rect, this.boundsMatrix);
            if (outBounds.isEmpty()) {
                outBounds.set(this.rect);
                continue;
            }
            outBounds.set(Math.min(outBounds.left, this.rect.left), Math.min(outBounds.top, this.rect.top), Math.max(outBounds.right, this.rect.right), Math.max(outBounds.bottom, this.rect.bottom));
        }
    }

    @Override
    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        super.setProgress(progress);
        if (this.timeRemapping != null) {
            float duration = this.lottieDrawable.getComposition().getDuration();
            long remappedTime = (long)(this.timeRemapping.getValue().floatValue() * 1000.0f);
            progress = (float)remappedTime / duration;
        }
        if (this.layerModel.getTimeStretch() != 0.0f) {
            progress /= this.layerModel.getTimeStretch();
        }
        progress -= this.layerModel.getStartProgress();
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).setProgress(progress);
        }
    }

    public boolean hasMasks() {
        if (this.hasMasks == null) {
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                BaseLayer layer = this.layers.get(i);
                if (layer instanceof ShapeLayer) {
                    if (!layer.hasMasksOnThisLayer()) continue;
                    this.hasMasks = true;
                    return true;
                }
                if (!(layer instanceof CompositionLayer) || !((CompositionLayer)layer).hasMasks()) continue;
                this.hasMasks = true;
                return true;
            }
            this.hasMasks = false;
        }
        return this.hasMasks;
    }

    public boolean hasMatte() {
        if (this.hasMatte == null) {
            if (this.hasMatteOnThisLayer()) {
                this.hasMatte = true;
                return true;
            }
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                if (!this.layers.get(i).hasMatteOnThisLayer()) continue;
                this.hasMatte = true;
                return true;
            }
            this.hasMatte = false;
        }
        return this.hasMatte;
    }

    @Override
    protected void resolveChildKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).resolveKeyPath(keyPath, depth, accumulator, currentPartialKeyPath);
        }
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        super.addValueCallback(property, callback);
        if (property == LottieProperty.TIME_REMAP) {
            if (callback == null) {
                this.timeRemapping = null;
            } else {
                this.timeRemapping = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.addAnimation(this.timeRemapping);
            }
        }
    }
}

