/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import android.util.Log;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatableShapeValue;
import com.airbnb.lottie.model.content.Mask;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

class MaskParser {
    private MaskParser() {
    }

    static Mask parse(JsonReader reader, LottieComposition composition) throws IOException {
        Mask.MaskMode maskMode = null;
        AnimatableShapeValue maskPath = null;
        AnimatableIntegerValue opacity = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String mode;
            block5 : switch (mode = reader.nextName()) {
                case "mode": {
                    switch (reader.nextString()) {
                        case "a": {
                            maskMode = Mask.MaskMode.MaskModeAdd;
                            break block5;
                        }
                        case "s": {
                            maskMode = Mask.MaskMode.MaskModeSubtract;
                            break block5;
                        }
                        case "i": {
                            maskMode = Mask.MaskMode.MaskModeIntersect;
                            break block5;
                        }
                    }
                    Log.w((String)"LOTTIE", (String)("Unknown mask mode " + mode + ". Defaulting to Add."));
                    maskMode = Mask.MaskMode.MaskModeAdd;
                    break;
                }
                case "pt": {
                    maskPath = AnimatableValueParser.parseShapeData(reader, composition);
                    break;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        return new Mask(maskMode, maskPath, opacity);
    }
}

