/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.value;

import android.support.annotation.NonNull;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;

public class LottieRelativeFloatValueCallback
extends LottieValueCallback<Float> {
    public LottieRelativeFloatValueCallback() {
    }

    public LottieRelativeFloatValueCallback(@NonNull Float staticValue) {
        super(staticValue);
    }

    @Override
    public Float getValue(LottieFrameInfo<Float> frameInfo) {
        float originalValue = MiscUtils.lerp(frameInfo.getStartValue().floatValue(), frameInfo.getEndValue().floatValue(), frameInfo.getInterpolatedKeyframeProgress());
        float offset = this.getOffset(frameInfo).floatValue();
        return Float.valueOf(originalValue + offset);
    }

    public Float getOffset(LottieFrameInfo<Float> frameInfo) {
        if (this.value == null) {
            throw new IllegalArgumentException("You must provide a static value in the constructor , call setValue, or override getValue.");
        }
        return (Float)this.value;
    }
}

