/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.porcupine.execution.control;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public class ExecutorConfiguration {
    private int corePoolSize;
    private int keepAliveTime;
    private int maxPoolSize;
    private int queueCapacity;
    private RejectedExecutionHandler rejectedExecutionHandler;

    private ExecutorConfiguration() {
        int availableProcessors;
        this.corePoolSize = availableProcessors = Runtime.getRuntime().availableProcessors();
        this.maxPoolSize = availableProcessors * 2;
        this.keepAliveTime = 1;
        this.queueCapacity = 100;
    }

    public static final ExecutorConfiguration defaultConfiguration() {
        return new ExecutorConfiguration();
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public static final class Builder {
        ExecutorConfiguration configuration = new ExecutorConfiguration();

        public Builder corePoolSize(int corePoolSize) {
            this.configuration.corePoolSize = corePoolSize;
            return this;
        }

        public Builder keepAliveTime(int keepAliveTime) {
            this.configuration.keepAliveTime = keepAliveTime;
            return this;
        }

        public Builder maxPoolSize(int maxPoolSize) {
            this.configuration.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder queueCapacity(int queueCapacity) {
            this.configuration.queueCapacity = queueCapacity;
            return this;
        }

        public Builder abortPolicy() {
            this.configuration.rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
            return this;
        }

        public Builder callerRunsPolicy() {
            this.configuration.rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
            return this;
        }

        public Builder discardPolicy() {
            this.configuration.rejectedExecutionHandler = new ThreadPoolExecutor.DiscardPolicy();
            return this;
        }

        public Builder discardOldestPolicy() {
            this.configuration.rejectedExecutionHandler = new ThreadPoolExecutor.DiscardOldestPolicy();
            return this;
        }

        public Builder customRejectedExecutionHandler(RejectedExecutionHandler reh) {
            this.configuration.rejectedExecutionHandler = reh;
            return this;
        }

        public ExecutorConfiguration build() {
            return this.configuration;
        }
    }
}

