/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.porcupine.execution.control;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class InstrumentedThreadPoolExecutor
extends ThreadPoolExecutor {
    private int minRemainingQueueCapacity;

    public InstrumentedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.minRemainingQueueCapacity = workQueue.remainingCapacity();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        int current = super.getQueue().remainingCapacity();
        this.minRemainingQueueCapacity = Math.min(this.minRemainingQueueCapacity, current);
    }

    public int getMinRemainingQueueCapacity() {
        return this.minRemainingQueueCapacity;
    }
}

