/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.porcupine.execution.entity;

import com.airhacks.porcupine.execution.control.InstrumentedThreadPoolExecutor;
import com.airhacks.porcupine.execution.entity.Statistics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

public class Pipeline {
    private final String pipelineName;
    private final InstrumentedThreadPoolExecutor tpe;
    private final AtomicLong rejectedTasks;

    public Pipeline(String pipelineName, InstrumentedThreadPoolExecutor tpe) {
        this.pipelineName = pipelineName;
        this.tpe = tpe;
        this.rejectedTasks = new AtomicLong();
    }

    public Statistics getStatistics() {
        int remainingQueueCapacity = this.tpe.getQueue().remainingCapacity();
        int minQueueCapacity = this.tpe.getMinRemainingQueueCapacity();
        int corePoolSize = this.tpe.getCorePoolSize();
        long completedTaskCount = this.tpe.getCompletedTaskCount();
        int activeThreadCount = this.tpe.getActiveCount();
        int largestThreadPoolSize = this.tpe.getLargestPoolSize();
        int currentThreadPoolSize = this.tpe.getPoolSize();
        long totalNumberOfTasks = this.tpe.getTaskCount();
        int maximumPoolSize = this.tpe.getMaximumPoolSize();
        RejectedExecutionHandler handler = this.tpe.getRejectedExecutionHandler();
        String rejectedExecutionHandlerName = null;
        if (handler != null) {
            rejectedExecutionHandlerName = handler.getClass().getSimpleName();
        }
        return new Statistics(this.pipelineName, remainingQueueCapacity, minQueueCapacity, completedTaskCount, activeThreadCount, corePoolSize, largestThreadPoolSize, currentThreadPoolSize, totalNumberOfTasks, maximumPoolSize, rejectedExecutionHandlerName, this.rejectedTasks.get());
    }

    public ExecutorService getExecutor() {
        return this.tpe;
    }

    public void shutdown() {
        this.tpe.shutdown();
    }

    public boolean manages(ThreadPoolExecutor executor) {
        return this.tpe == executor;
    }

    public void taskRejected() {
        this.rejectedTasks.incrementAndGet();
    }
}

