/**
 * 版权所有 2017 Sp42 frank@ajaxjs.com
 * 
 * 根据 2.0 版本 Apache 许可证("许可证")授权；
 * 根据本许可证，用户可以不使用此文件。
 * 用户可从下列网址获得许可证副本：
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 *    
 * 除非因适用法律需要或书面同意，根据许可证分发的软件是基于"按原样"基础提供，
 * 无任何明示的或暗示的保证或条件。详见根据许可证许可下，特定语言的管辖权限和限制。
 */
package com.ajaxjs.framework.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ajaxjs.util.Encode;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.collection.MapHelper;

/**
 * DAO 用的查询参数，可以是 分页 的查询参数，也可以是排序、过滤、搜索等的参数 * 查询时特地需求的容器，可包含特定的对象进行查询，通过
 * getter/setter 注入。 特定的对象一般为 Map 结果。最后转化为 SQL 字符串。 通常是耦合
 * HttpServletRequest.getParameterMap() 返回请求数据
 * 
 * @author Sp42 frank@ajaxjs.com
 *
 */
public class QueryParams {
	public QueryParams(int start, int limit) {
		if (limit == 0)
			limit = defaultPageSize;

		pageParam[0] = start;
		pageParam[1] = limit;
	}

	/**
	 * 分页之起始行数\偏量值
	 */
	public final int[] pageParam = new int[2];

	/**
	 * 默认每页显示记录数
	 */
	private static int defaultPageSize = 5;

	/**
	 * 
	 * @param requestData
	 *            请求参数
	 */
	public QueryParams(Map<String, String[]> requestData) {
//		if(requestData.containsKey("start"))
//			pageParam[0] = Integer.parseInt(requestData.get("start").toString());
//		if(requestData.containsKey("limit"))
//			pageParam[1] = Integer.parseInt(requestData.get("limit").toString());

		QueryParamRequestData(requestData);
	}

	/**
	 * 
	 * @param start
	 * @param limit
	 * @param requestData
	 *            请求参数
	 */
	public QueryParams(int start, int limit, Map<String, String[]> requestData) {
		this(start, limit);
		QueryParamRequestData(requestData);
	}

	/**
	 * 
	 * @param requestData
	 *            请求参数
	 */
	public void QueryParamRequestData(Map<String, String[]> requestData) {
		set(requestData, "filterField", "filterValue");// where 查询（模糊）
		set(requestData, "searchField", "searchValue");// search 查询（模糊）
		set(requestData, "matchField", "matchValue");// match 查询（精确）
		set(requestData, "orderField", "orderField");// order 查询
	}

	private void set(Map<String, String[]> requestData, String key, String value) {
		if (requestData.containsKey(key) && requestData.containsKey(value))
			setData(key, MapHelper.toMap(requestData.get(key), requestData.get(value)));
	}

	private void setData(String type, Map<String, Object> data) {
		switch (type) {
		case "filterField":
			filter = data;
			break;
		case "searchField":
			search = data;
			break;
		case "matchField":
			match = data;
			break;
		case "orderField":
			order = data;
		}
	}

	public Map<String, Object> filter = null, search = null, match = null, order = null;

	/**
	 * 添加 WHERE 子语句
	 * 
	 * @param sql
	 *            输入的原 SQL 语句
	 */
	public String addWhereToSql(String sql) {
		List<String> wheres = new ArrayList<>();
		if (filter != null) {
			for (String key : filter.keySet()) 
				wheres.add(key + " = " + Encode.urlChinese(filter.get(key).toString()));
		}

		if (search != null) {
			for (String key : search.keySet()) 
				wheres.add(key + " LIKE '%" + Encode.urlChinese(search.get(key).toString()) + "%'");
		}

		if (match != null) {
			for (String key : match.keySet()) 
				wheres.add(key + " LIKE '" + Encode.urlChinese(match.get(key).toString()) + "'");
		}

		// 增加到原 sql 身上
		if (wheres.size() > 0) {
			String c = StringUtil.stringJoin(wheres, " AND ");

			String regexp = "(?i)1\\s?(=|AND)\\s?1"; // 支持 1=1、1 AND 1
			if (StringUtil.regMatch(regexp, sql) != null) {
				sql = sql.replaceAll(regexp, c);
			} else if (sql.contains("WHERE")) {
				sql = sql.replaceAll("WHERE", "WHERE " + c + " AND ");// 写死 AND 并关系，但如果要 OR 呢？
			} else {
				sql += " WHERE " + c;
			}
		}

		return sql;
	}

	/**
	 * 转化 ORDER BY
	 * 
	 * @param sql
	 *            输入的原 SQL 语句
	 * @return 添加了 ORDER BY 子语句的 SQL 语句
	 */
	public String orderToSql(String sql) {
		if (order != null) {
			List<String> orders = new ArrayList<>();

			for (String key : order.keySet()) {
				orders.add(key + " " + order.get(key));
			}

			String orderBy = StringUtil.stringJoin(orders, ",");

			if (sql.toUpperCase().contains("ORDER BY ")) {
				sql = sql.replaceAll("(?i)ORDER BY ", "ORDER BY " + orderBy + ", ");
			} else {
				sql += " ORDER BY " + orderBy;
			}
		}

		return sql;
	}
}
