/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.dao;

import com.ajaxjs.framework.dao.DaoException;
import com.ajaxjs.framework.dao.QueryParams;
import com.ajaxjs.framework.dao.annotation.Delete;
import com.ajaxjs.framework.dao.annotation.Insert;
import com.ajaxjs.framework.dao.annotation.Select;
import com.ajaxjs.framework.dao.annotation.Update;
import com.ajaxjs.jdbc.Helper;
import com.ajaxjs.jdbc.JdbcConnection;
import com.ajaxjs.jdbc.PageResult;
import com.ajaxjs.jdbc.SimpleORM;
import com.ajaxjs.util.collection.CollectionUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class DaoHandler<T>
implements InvocationHandler {
    private static final LogHelper LOGGER = LogHelper.getLog(DaoHandler.class);
    private Connection conn;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws DaoException {
        if (method.getName().equals("toString")) {
            return "This is a AJAXJS DAO.";
        }
        this.setConn(JdbcConnection.getConnection());
        if (this.getConn() == null) {
            throw new DaoException("\u6ca1\u6709 connection\uff0c \u8bf7\u5148\u5efa\u7acb\u6570\u636e\u5e93\u8fde\u63a5\u5bf9\u8c61\u3002");
        }
        Class<?> returnType = method.getReturnType();
        Class<?> entryType = null;
        if (method.getAnnotation(Select.class) != null) {
            entryType = DaoHandler.getEntryContainerType(method);
            return this.select(method.getAnnotation(Select.class), args, returnType, entryType);
        }
        if (args == null || args[0] == null) {
            throw new DaoException("DAO \u63a5\u53e3\u65b9\u6cd5\u7b7e\u540d\u7f3a\u5c11\u5b9e\u4f53\u53c2\u6570\uff01");
        }
        entryType = args[0].getClass();
        if (method.getAnnotation(Insert.class) != null) {
            return this.insert(method.getAnnotation(Insert.class), args, returnType, entryType);
        }
        if (method.getAnnotation(Update.class) != null) {
            return this.update(method.getAnnotation(Update.class), args, entryType);
        }
        if (method.getAnnotation(Delete.class) != null) {
            return this.delete(method.getAnnotation(Delete.class), args, entryType);
        }
        throw new DaoException("\u6ca1\u6709\u4efb\u4f55 DAO CRUD \u7684\u6ce8\u89e3\u3002" + method);
    }

    public T bind(Class<T> clz) {
        Object obj = Proxy.newProxyInstance(clz.getClassLoader(), new Class[]{clz}, (InvocationHandler)this);
        return (T)obj;
    }

    private static Class<?> getEntryContainerType(Method method) {
        ParameterizedType _type;
        Type[] arr$;
        int len$;
        int i$;
        Type returnType;
        Class<?> type = method.getReturnType();
        if ((type == List.class || type == PageResult.class) && (returnType = method.getGenericReturnType()) instanceof ParameterizedType && (i$ = 0) < (len$ = (arr$ = (_type = (ParameterizedType)returnType).getActualTypeArguments()).length)) {
            Type typeArgument = arr$[i$];
            if (typeArgument instanceof ParameterizedTypeImpl) {
                return Map.class;
            }
            return (Class)typeArgument;
        }
        return type;
    }

    private <R, B> Object select(Select select, Object[] args, Class<R> returnType, Class<B> entryType) throws DaoException {
        String sql = select.value();
        SimpleORM<B> orm = new SimpleORM<B>(this.conn, entryType);
        if (returnType == Integer.TYPE) {
            return Helper.queryOne(this.conn, sql, Integer.TYPE, args);
        }
        if (returnType == Integer[].class) {
            return Helper.queryArray(this.conn, sql, Integer.class, args);
        }
        if (returnType == String.class) {
            return Helper.queryOne(this.conn, sql, String.class, args);
        }
        if (returnType == List.class || returnType == PageResult.class) {
            QueryParams queryParam = DaoHandler.getQueryParam(args);
            if (queryParam != null) {
                args = DaoHandler.removeItem(args, queryParam);
                sql = queryParam.orderToSql(sql);
                sql = queryParam.addWhereToSql(sql);
            }
            if (returnType == List.class) {
                return orm.queryList(sql, args);
            }
            return this.page(queryParam, sql, args, orm);
        }
        return orm.query(sql, args);
    }

    private <B> PageResult<B> page(QueryParams queryParam, String sql, Object[] args, SimpleORM<B> orm) throws DaoException {
        if (queryParam.pageParam.length != 2) {
            throw new IllegalArgumentException("\u6ca1\u6709\u5206\u9875\u53c2\u6570\uff01");
        }
        String countSql = sql.replaceAll("SELECT.*FROM", "SELECT COUNT(\\*) AS count FROM");
        Object obj = Helper.queryOne(this.conn, countSql, Object.class, args);
        int total = obj instanceof Integer ? (Integer)obj : Integer.parseInt(obj + "");
        PageResult<B> result = new PageResult<B>();
        if (total <= 0) {
            LOGGER.info("\u6ca1\u6709\u6570\u636e\uff0csql\uff1a" + countSql);
            DaoException e = new DaoException("\u67e5\u8be2\u6210\u529f\uff0c\u4f46\u6ca1\u6709\u6570\u636e\uff0c\u8fd4\u56de\u7ed3\u679c\u884c\u6570\u4e3a\u96f6");
            e.setZero(true);
            throw e;
        }
        result.setStart(queryParam.pageParam[0]);
        result.setPageSize(queryParam.pageParam[1]);
        result.setTotalCount(total);
        result.page();
        List<B> list = orm.queryList(sql + " LIMIT " + result.getStart() + ", " + result.getPageSize(), args);
        result.setRows(list);
        return result;
    }

    private static QueryParams getQueryParam(Object[] args) {
        if (CollectionUtil.isNull((Object[])args)) {
            return null;
        }
        for (int i = args.length - 1; i >= 0; --i) {
            if (!(args[i] instanceof QueryParams)) continue;
            return (QueryParams)args[i];
        }
        return null;
    }

    static Object[] removeItem(Object[] objs, Object item) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(objs));
        list.remove(item);
        return list.size() > 0 ? list.toArray() : null;
    }

    private <R, B> Object insert(Insert insert, Object[] args, Class<R> returnType, Class<B> beanType) {
        Serializable id = null;
        if (!insert.value().equals("")) {
            id = Helper.create(this.conn, insert.value(), args);
        } else if (insert.value().equals("") && insert.tableName() != null && args[0] != null) {
            id = new SimpleORM<B>(this.conn, beanType).create(args[0], insert.tableName());
        }
        if (returnType == Integer.class && id.getClass() == Long.class) {
            return Integer.parseInt("" + id);
        }
        if (returnType == Long.class && id.getClass() == Integer.class) {
            return new Long(((Integer)id).intValue());
        }
        return id;
    }

    private <R, B> Integer update(Update update, Object[] args, Class<B> beanType) {
        int effectRows = 0;
        if (!update.value().equals("")) {
            effectRows = Helper.update(this.conn, update.value(), args);
        } else if (update.value().equals("") && update.tableName() != null && args[0] != null) {
            effectRows = new SimpleORM<B>(this.conn, beanType).update(args[0], update.tableName());
        }
        return effectRows;
    }

    private <R, B> Boolean delete(Delete delete, Object[] args, Class<B> beanType) {
        boolean isOk = false;
        if (!delete.value().equals("")) {
            isOk = Helper.delete(this.conn, delete.value(), (Serializable)args);
        } else if (delete.value().equals("") && delete.tableName() != null && args[0] != null) {
            isOk = new SimpleORM<B>(this.conn, beanType).delete(args[0], delete.tableName());
        }
        return isOk;
    }

    public Connection getConn() {
        return this.conn;
    }

    public DaoHandler<T> setConn(Connection conn) {
        this.conn = conn;
        return this;
    }
}

