/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.dao;

import com.ajaxjs.util.Encode;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.collection.MapHelper;
import java.util.ArrayList;
import java.util.Map;

public class QueryParams {
    public final int[] pageParam = new int[2];
    private static int defaultPageSize = 5;
    public Map<String, Object> filter = null;
    public Map<String, Object> search = null;
    public Map<String, Object> match = null;
    public Map<String, Object> order = null;

    public QueryParams(int start, int limit) {
        if (limit == 0) {
            limit = defaultPageSize;
        }
        this.pageParam[0] = start;
        this.pageParam[1] = limit;
    }

    public QueryParams(Map<String, String[]> requestData) {
        this.QueryParamRequestData(requestData);
    }

    public QueryParams(int start, int limit, Map<String, String[]> requestData) {
        this(start, limit);
        this.QueryParamRequestData(requestData);
    }

    public void QueryParamRequestData(Map<String, String[]> requestData) {
        this.set(requestData, "filterField", "filterValue");
        this.set(requestData, "searchField", "searchValue");
        this.set(requestData, "matchField", "matchValue");
        this.set(requestData, "orderField", "orderField");
    }

    private void set(Map<String, String[]> requestData, String key, String value) {
        if (requestData.containsKey(key) && requestData.containsKey(value)) {
            this.setData(key, MapHelper.toMap((String[])requestData.get(key), (String[])requestData.get(value)));
        }
    }

    private void setData(String type, Map<String, Object> data) {
        switch (type) {
            case "filterField": {
                this.filter = data;
                break;
            }
            case "searchField": {
                this.search = data;
                break;
            }
            case "matchField": {
                this.match = data;
                break;
            }
            case "orderField": {
                this.order = data;
            }
        }
    }

    public String addWhereToSql(String sql) {
        ArrayList<String> wheres = new ArrayList<String>();
        if (this.filter != null) {
            for (String key : this.filter.keySet()) {
                wheres.add(key + " = " + Encode.urlChinese((String)this.filter.get(key).toString()));
            }
        }
        if (this.search != null) {
            for (String key : this.search.keySet()) {
                wheres.add(key + " LIKE '%" + Encode.urlChinese((String)this.search.get(key).toString()) + "%'");
            }
        }
        if (this.match != null) {
            for (String key : this.match.keySet()) {
                wheres.add(key + " LIKE '" + Encode.urlChinese((String)this.match.get(key).toString()) + "'");
            }
        }
        if (wheres.size() > 0) {
            String c = StringUtil.stringJoin(wheres, (String)" AND ");
            String regexp = "(?i)1\\s?(=|AND)\\s?1";
            sql = StringUtil.regMatch((String)regexp, (String)sql) != null ? sql.replaceAll(regexp, c) : (sql.contains("WHERE") ? sql.replaceAll("WHERE", "WHERE " + c + " AND ") : sql + " WHERE " + c);
        }
        return sql;
    }

    public String orderToSql(String sql) {
        if (this.order != null) {
            ArrayList<String> orders = new ArrayList<String>();
            for (String key : this.order.keySet()) {
                orders.add(key + " " + this.order.get(key));
            }
            String orderBy = StringUtil.stringJoin(orders, (String)",");
            sql = sql.toUpperCase().contains("ORDER BY ") ? sql.replaceAll("(?i)ORDER BY ", "ORDER BY " + orderBy + ", ") : sql + " ORDER BY " + orderBy;
        }
        return sql;
    }
}

