/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.mock;

import com.ajaxjs.framework.mock.News;
import com.ajaxjs.jdbc.JdbcConnection;
import com.ajaxjs.util.io.resource.Scanner;
import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.sqlite.SQLiteDataSource;
import org.sqlite.SQLiteJDBCLoader;

public class MockDataSource {
    public static final String testUsed_sqlite = Scanner.getResourceFilePath(News.class, (String)"foo.sqlite");

    private static InitialContext initIc() {
        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
        try {
            InitialContext ic = new InitialContext();
            ic.createSubcontext("java:");
            ic.createSubcontext("java:/comp");
            ic.createSubcontext("java:/comp/env");
            ic.createSubcontext("java:/comp/env/jdbc");
            return ic;
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DataSource getDataSource(String db_filePath) {
        try {
            SQLiteJDBCLoader.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SQLiteDataSource dataSource = new SQLiteDataSource();
        dataSource.setUrl("jdbc:sqlite:" + db_filePath);
        return dataSource;
    }

    public static DataSource getDataSource() {
        return MockDataSource.getDataSource(testUsed_sqlite);
    }

    public static Connection getTestConnection() {
        return JdbcConnection.getConnection(MockDataSource.getDataSource(testUsed_sqlite));
    }

    public static Connection getTestMySqlConnection(String url, String user, String password) {
        return JdbcConnection.getConnection(MockDataSource.getMySqlDataSource(url, user, password));
    }

    public static void initSqliteDBConnection(String db_filePath) {
        try {
            MockDataSource.initIc().bind("java:/comp/env/jdbc/sqlite", (Object)MockDataSource.getDataSource(db_filePath));
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public static DataSource getMySqlDataSource(String url, String user, String password) {
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setURL(url);
        dataSource.setUser(user);
        dataSource.setPassword(password);
        return dataSource;
    }
}

