/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.service.aop;

import com.ajaxjs.aop.Aop;
import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.framework.service.IService;
import com.ajaxjs.framework.service.ServiceException;
import com.ajaxjs.framework.service.plugin.Catalog;
import com.ajaxjs.util.SnowflakeIdWorker;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;

public class CommonService<T, ID extends Serializable, S extends IService<T, ID>>
extends Aop<S> {
    private static final ValidatorFactory avf = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory();

    public Object before(S obj, Method method, String methodName, Object[] args) throws Throwable {
        if ("create".equals(methodName)) {
            if (args[0] instanceof BaseModel) {
                BaseModel model = (BaseModel)args[0];
                CommonService.onCreate(model);
                CommonService.validate(model);
            }
            if (args[0] instanceof Map) {
                CommonService.onCreate((Map)args[0]);
            }
        }
        if ("update".equals(methodName) && args[0] instanceof BaseModel) {
            CommonService.onUpdate((BaseModel)args[0]);
        }
        return null;
    }

    private static void validate(BaseModel model) throws ServiceException {
        Validator validator = avf.getValidator();
        Set result = validator.validate((Object)model, new Class[0]);
        if (!result.isEmpty()) {
            String err = "";
            for (ConstraintViolation r : result) {
                err = err + r.getPropertyPath() + ":" + r.getMessage();
            }
            throw new ServiceException("\u6570\u636e\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01" + err);
        }
    }

    public void after(S obj, Method method, String methodName, Object[] args, Object returnObj) {
        if ("create".equals(methodName)) {
            BaseModel model = null;
            if (args[0] instanceof BaseModel) {
                model = (BaseModel)args[0];
                model.setId((long)((Long)returnObj));
            }
        }
        if ("findPagedList".equals(methodName)) {
            Catalog.doAfter(obj, returnObj);
        }
    }

    public static void onCreate(BaseModel model) {
        SnowflakeIdWorker idWorker = new SnowflakeIdWorker(0L, 0L);
        model.setUid(idWorker.nextId());
        Date now = new Date();
        if (model.getCreateDate() == null) {
            model.setCreateDate(now);
        }
        if (model.getUpdateDate() == null) {
            model.setUpdateDate(now);
        }
    }

    public static void onUpdate(BaseModel model) {
        Date now = new Date();
        if (model.getUpdateDate() == null) {
            model.setUpdateDate(now);
        }
    }

    public static void onCreate(Map<String, Object> map) {
        SnowflakeIdWorker idWorker = new SnowflakeIdWorker(0L, 0L);
        map.put("uid", idWorker.nextId());
        Date now = new Date();
        map.put("createDate", now);
        map.put("updateDate", now);
    }

    public static void onUpdate(Map<String, Object> map) {
        Date now = new Date();
        map.put("updateDate", now);
    }
}

