/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.service.aop;

import com.ajaxjs.aop.Aop;
import com.ajaxjs.framework.service.IService;
import com.ajaxjs.framework.service.ServiceException;
import com.ajaxjs.framework.service.annotation.ValidIt;
import com.ajaxjs.framework.service.annotation.ValidObj;
import com.ajaxjs.util.logger.LogHelper;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;

public class ValidationService<T, ID extends Serializable, S extends IService<T, ID>>
extends Aop<S> {
    private static final LogHelper LOGGER = LogHelper.getLog(ValidationService.class);
    private static final ValidatorFactory avf = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory();

    public Object before(S service, Method method, String methodName, Object[] args) throws Throwable {
        if (!method.isAnnotationPresent(ValidIt.class) || args.length == 0) {
            return null;
        }
        T bean = this.getBean(method, args);
        if (bean == null) {
            return null;
        }
        Validator v = ValidationService.getValidator();
        Set results = v.validate(bean, new Class[0]);
        if (!results.isEmpty()) {
            String str = "";
            for (ConstraintViolation result : results) {
                str = str + result.getPropertyPath() + result.getMessage() + "\\n";
                LOGGER.info(result.getPropertyPath() + ":" + result.getMessage());
            }
            throw new ServiceException("\u6821\u9a8c\u5931\u8d25\u3002\u5177\u4f53\u539f\u56e0\uff1a" + str);
        }
        return null;
    }

    public void after(S service, Method method, String methodName, Object[] args, Object returnObj) {
    }

    private T getBean(Method method, Object[] args) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] pa;
            for (Annotation a : pa = parameterAnnotations[i]) {
                if (a.annotationType() != ValidObj.class) continue;
                return (T)args[i];
            }
        }
        return null;
    }

    public static Validator getValidator() {
        return avf.getValidator();
    }
}

