/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jdbc;

import com.ajaxjs.jdbc.JdbcConnection;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Helper {
    private static final LogHelper LOGGER = LogHelper.getLog(Helper.class);

    public static Map<String, Object> query(Connection conn, String sql, Object ... params) {
        Map<String, Object> map = null;
        LOGGER.info("The SQL is------------>\n" + Helper.printRealSql(sql, params));
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                if (Helper.isMySql(conn) ? rs.next() : rs.isBeforeFirst()) {
                    map = Helper.getResultMap(rs);
                } else {
                    LOGGER.info("\u67e5\u8be2 SQL\uff1a{0} \u6ca1\u6709\u7b26\u5408\u7684\u8bb0\u5f55\uff01", new Object[]{sql});
                }
            }
        }
        catch (SQLException e) {
            LOGGER.warning((Throwable)e);
        }
        return map;
    }

    public static List<Map<String, Object>> queryList(Connection conn, String sql, Object ... params) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        LOGGER.info("The SQL is------------>\n" + Helper.printRealSql(sql, params));
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(Helper.getResultMap(rs));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.warning((Throwable)e);
        }
        return list.size() == 0 ? null : list;
    }

    public static <T> T[] queryArray(Connection conn, String sql, Class<T> clz, Object ... params) {
        ArrayList<Object> list = new ArrayList<Object>();
        LOGGER.info("The SQL is------------>\n" + Helper.printRealSql(sql, params));
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(rs.getObject(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.warning((Throwable)e);
        }
        Object array = Array.newInstance(clz, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return (Object[])array;
    }

    public static <T> T queryOne(Connection conn, String sql, Class<T> clz, Object ... params) {
        Iterator<String> i$;
        Map<String, Object> map = Helper.query(conn, sql, params);
        if (map != null && (i$ = map.keySet().iterator()).hasNext()) {
            String key = i$.next();
            return (T)map.get(key);
        }
        return null;
    }

    public static Map<String, Object> getResultMap(ResultSet rs) throws SQLException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String key = rsmd.getColumnLabel(i);
            Object value = rs.getObject(i);
            map.put(key, value);
        }
        return map;
    }

    private static boolean isMySql(Connection conn) {
        String connStr = conn.toString();
        return connStr.indexOf("MySQL") != -1 || connStr.indexOf("mysql") != -1;
    }

    public static Serializable create(Connection conn, String sql, Object ... params) {
        String _sql = Helper.printRealSql(sql, params);
        JdbcConnection.addSql(_sql);
        LOGGER.info("The SQL is------------>\n" + _sql);
        Object newlyId = null;
        try (PreparedStatement ps = conn.prepareStatement(sql, 1);){
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.executeUpdate();
            try (ResultSet rs = ps.getGeneratedKeys();){
                if (rs.next()) {
                    newlyId = rs.getObject(1);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.warning((Throwable)e);
        }
        if (!(newlyId instanceof Serializable)) {
            LOGGER.warning(String.format("\u8fd4\u56de id :{0} \u7c7b\u578b:{1}", newlyId, newlyId.getClass().getName()));
            throw new RuntimeException("\u8fd4\u56de id \u7c7b\u578b\u4e0d\u662f Serializable");
        }
        return (Serializable)newlyId;
    }

    public static int update(Connection conn, String sql, Object ... params) {
        int effectRows = 0;
        String _sql = Helper.printRealSql(sql, params);
        JdbcConnection.addSql(_sql);
        LOGGER.info("The SQL is------------>\n" + _sql);
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            effectRows = ps.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.warning((Throwable)e);
        }
        return effectRows;
    }

    public static boolean delete(Connection conn, String tableName, Serializable id) {
        return Helper.update(conn, "DELETE FROM " + tableName + " WHERE id = ?", id) == 1;
    }

    public static String printRealSql(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            return sql;
        }
        if (!Helper.match(sql, params)) {
            LOGGER.info("SQL \u8bed\u53e5\u4e2d\u7684\u5360\u4f4d\u7b26\u4e0e\u503c\u53c2\u6570\uff08\u4e2a\u6570\u4e0a\uff09\u4e0d\u5339\u914d\u3002SQL\uff1a{0}\uff0cparams:{1}", new Object[]{sql, params});
            return null;
        }
        int cols = params.length;
        Object[] values = new Object[cols];
        System.arraycopy(params, 0, values, 0, cols);
        for (int i = 0; i < cols; ++i) {
            Object value = values[i];
            if (value instanceof Date) {
                values[i] = "'" + value + "'";
                continue;
            }
            if (value instanceof String) {
                values[i] = "'" + value + "'";
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            values[i] = (Boolean)value != false ? 1 : 0;
        }
        String statement = String.format(sql.replaceAll("\\?", "%s"), values);
        return statement;
    }

    private static boolean match(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            return true;
        }
        Matcher m = Pattern.compile("(\\?)").matcher(sql);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count == params.length;
    }

    public static String formatSql(String sql) {
        String separator = System.getProperty("line.separator");
        sql = '\t' + sql;
        sql = sql.replaceAll("(?i)SELECT\\s+", "SELECT ");
        sql = sql.replaceAll("\\s+(?i)FROM", separator + "\tFROM");
        sql = sql.replaceAll("\\s+(?i)WHERE", separator + "\tWHERE");
        sql = sql.replaceAll("\\s+(?i)GROUP BY", separator + "\tGROUP BY");
        sql = sql.replaceAll("\\s+(?i)ORDER BY", separator + "\tORDER BY");
        sql = sql.replaceAll("\\s+(?i)LIMIT", separator + "\tLIMIT");
        sql = sql.replaceAll("\\s+(?i)DESC", " DESC");
        sql = sql.replaceAll("\\s+(?i)ASC", " ASC");
        return sql;
    }

    public static String getPlaceHolder(int len) {
        String[] placeHolders = new String[len];
        for (int i = 0; i < placeHolders.length; ++i) {
            placeHolders[i] = "?";
        }
        return StringUtil.stringJoin((String[])placeHolders, (String)",");
    }

    public static String getFields(Map<String, Object> pair, boolean isFieldName_Only) {
        String[] fields = new String[pair.size()];
        int i = 0;
        for (String field : pair.keySet()) {
            fields[i++] = isFieldName_Only ? field : field + " = ?";
        }
        return StringUtil.stringJoin((String[])fields, (String)", ");
    }
}

