/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jdbc;

import com.ajaxjs.util.logger.LogHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JdbcConnection {
    private static final LogHelper LOGGER = LogHelper.getLog(JdbcConnection.class);
    private static ThreadLocal<Connection> connection = new ThreadLocal();
    private static ThreadLocal<List<String>> sqls = new ThreadLocal();

    public static DataSource getDataSource(String path) {
        try {
            Object obj = new InitialContext().lookup("java:/comp/env");
            if (obj == null) {
                throw new NullPointerException("\u6ca1\u6709\u8be5\u8282\u70b9 java:/comp/env");
            }
            Context context = (Context)obj;
            return (DataSource)context.lookup(path);
        }
        catch (NamingException e) {
            LOGGER.warning("\u8bfb\u53d6\u6570\u636e\u6e90\u7684\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 Tomcat \u8fde\u63a5\u6c60\u914d\u7f6e\uff01 path:" + path, new Object[]{e});
            return null;
        }
    }

    public static Connection getConnection(DataSource source) {
        try {
            return source.getConnection();
        }
        catch (SQLException e) {
            LOGGER.warning("\u901a\u8fc7\u6570\u636e\u6e90\u5bf9\u8c61\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5\u5bf9\u8c61\u5931\u8d25\uff01", new Object[]{e});
            return null;
        }
    }

    public static Connection getConnection(String jdbcUrl, Properties props) {
        Connection conn = null;
        if (jdbcUrl.indexOf("mysql") != -1) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            conn = props == null ? DriverManager.getConnection(jdbcUrl) : DriverManager.getConnection(jdbcUrl, props);
            LOGGER.info("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f\uff1a " + conn.getMetaData().getURL());
        }
        catch (SQLException e) {
            e.printStackTrace();
            LOGGER.warning("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01", new Object[]{e});
        }
        return conn;
    }

    public static Connection getConnection(String jdbcUrl) {
        return JdbcConnection.getConnection(jdbcUrl, null);
    }

    public static Connection getConnection() {
        return connection.get();
    }

    public static List<String> getSqls() {
        return sqls.get();
    }

    public static void setConnection(Connection conn) {
        connection.set(conn);
    }

    public static void setSqls(List<String> _sqls) {
        sqls.set(_sqls);
    }

    public static void addSql(String sql) {
        if (JdbcConnection.getSqls() == null) {
            JdbcConnection.setSqls(new ArrayList<String>());
        }
        JdbcConnection.getSqls().add(sql);
    }

    public static void cleanSql() {
        if (JdbcConnection.getSqls() != null) {
            JdbcConnection.getSqls().clear();
        }
        sqls.set(null);
    }

    public static void clean() {
        connection.set(null);
        JdbcConnection.cleanSql();
    }
}

