/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jdbc;

import com.ajaxjs.jdbc.Helper;
import com.ajaxjs.jdbc.sqlbuilder.CommonSQL;
import com.ajaxjs.util.collection.CollectionUtil;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.reflect.BeanUtil;
import com.ajaxjs.util.reflect.ExecuteMethod;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimpleORM<E>
extends Helper {
    private static final LogHelper LOGGER = LogHelper.getLog(SimpleORM.class);
    private Class<E> entryType;
    private Connection conn;

    public SimpleORM(Connection conn, Class<E> entryType) {
        this.conn = conn;
        this.setEntryType(entryType);
    }

    public E query(String sql, Object ... params) {
        Map<String, Object> map = SimpleORM.query(this.conn, sql, params);
        if (map == null) {
            return null;
        }
        return (E)(this.entryType == Map.class ? map : BeanUtil.map2Bean(map, this.entryType, (boolean)true));
    }

    public List<E> queryList(String sql, Object ... params) {
        List<Map<String, Object>> list = SimpleORM.queryList(this.conn, sql, params);
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        if (this.entryType == Map.class) {
            return list;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Map<String, Object> map : list) {
            l.add(BeanUtil.map2Bean(map, this.entryType, (boolean)true));
        }
        return l;
    }

    public Serializable create(E bean, String tableName) {
        try {
            if (bean instanceof Map) {
                LOGGER.info("DAO \u521b\u5efa\u8bb0\u5f55 name:{0}\uff01", new Object[]{((Map)bean).get("name")});
            } else {
                LOGGER.info("DAO \u521b\u5efa\u8bb0\u5f55 name:{0}\uff01", new Object[]{ExecuteMethod.executeMethod(bean, (String)"getName", (Object[])new Object[0])});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CommonSQL sql = new CommonSQL();
        Object[] values = sql.insert(bean, tableName);
        Serializable newlyId = SimpleORM.create(this.conn, sql.toString(), values);
        if (bean instanceof Map) {
            Map map = (Map)bean;
            map.put("id", newlyId);
        } else {
            try {
                Class<?> idClz = bean.getClass().getMethod("getId", new Class[0]).getReturnType();
                if (Long.class == idClz && newlyId instanceof Integer) {
                    ExecuteMethod.executeMethod(bean, (String)"setId", (Object[])new Object[]{new Long(((Integer)newlyId).intValue())});
                } else {
                    ExecuteMethod.executeMethod(bean, (String)"setId", (Object[])new Object[]{newlyId});
                }
            }
            catch (Throwable e) {
                LOGGER.warning(e);
            }
        }
        return newlyId;
    }

    public int update(E bean, String tableName) {
        try {
            LOGGER.info("DAO \u66f4\u65b0\u8bb0\u5f55 id:{0}, name:{1}\uff01", new Object[]{ExecuteMethod.executeMethod(bean, (String)"getId", (Object[])new Object[0]), ExecuteMethod.executeMethod(bean, (String)"getName", (Object[])new Object[0])});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CommonSQL sql = new CommonSQL();
        Object[] values = sql.update(bean, tableName);
        return SimpleORM.update(this.conn, sql.toString(), values);
    }

    public boolean delete(E bean, String tableName) {
        Serializable id;
        if (bean instanceof Map) {
            Map map = (Map)bean;
            id = (Serializable)map.get("id");
        } else {
            try {
                id = (Serializable)ExecuteMethod.executeMethod(bean, (String)"getId", (Object[])new Object[0]);
            }
            catch (Throwable e) {
                throw new RuntimeException("\u83b7\u53d6 bean \u5b9e\u4f53\u4e4b id \u5931\u8d25\uff01");
            }
        }
        LOGGER.info("DAO \u5220\u9664\u8bb0\u5f55 id:{0}", new Object[]{id});
        return SimpleORM.delete(this.conn, tableName, id);
    }

    public Class<E> getEntryType() {
        return this.entryType;
    }

    public void setEntryType(Class<E> entryType) {
        this.entryType = entryType;
    }
}

