/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jdbc;

import com.ajaxjs.jdbc.Helper;
import com.ajaxjs.jdbc.PageResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class SimplePager {
    private Connection conn;
    private String sql;
    private int pageSize = 5;
    private int start;

    public SimplePager(Connection conn, String sql, int start) {
        this.conn = conn;
        this.sql = sql;
        this.start = start;
    }

    public SimplePager(Connection conn, String sql, String start) {
        this.conn = conn;
        this.sql = sql;
        this.start = start == null ? 0 : Integer.parseInt(start);
    }

    public PageResult<Map<String, Object>> getResult() {
        int total = this.getTotal();
        if (total > 0) {
            String _sql = this.sql + String.format(" LIMIT %d, %d", this.start, this.pageSize);
            List<Map<String, Object>> results = Helper.queryList(this.conn, _sql, new Object[0]);
            PageResult<Map<String, Object>> pr = new PageResult<Map<String, Object>>();
            pr.setRows(results);
            pr.setStart(this.start);
            pr.setPageSize(this.pageSize);
            pr.setTotalCount(total);
            pr.page();
            return pr;
        }
        return null;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getTotal() {
        String _sql = this.sql.replaceAll("SELECT", "SELECT COUNT(\\*) AS count, ");
        try (Statement statement = this.conn.createStatement();
             ResultSet rs = statement.executeQuery(_sql);){
            if (rs.isBeforeFirst()) {
                int n = rs.getInt(1);
                return n;
            }
            System.err.println("\u67e5\u8be2 SQL\uff1a" + this.sql + " \u6ca1\u6709\u7b26\u5408\u7684\u8bb0\u5f55\uff01");
            return 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

