/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jdbc.sqlbuilder;

import com.ajaxjs.jdbc.sqlbuilder.SqlBuilder;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.reflect.BeanUtil;
import com.ajaxjs.util.reflect.ExecuteMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommonSQL
extends SqlBuilder {
    private static final LogHelper LOGGER = LogHelper.getLog(CommonSQL.class);

    public Object[] insert(Object bean, String tableName) {
        this.INSERT_INTO(tableName);
        List<Object> values = new ArrayList();
        if (bean instanceof Map) {
            values = this.mapToSql(bean, false);
        } else {
            List<String> methodNames = this.addFieldValues(bean, false, null);
            for (String methodName : methodNames) {
                values.add(ExecuteMethod.executeMethod((Object)bean, (String)methodName, (Object[])new Object[0]));
            }
        }
        return values.toArray();
    }

    public Object[] update(Object bean, String tableName) {
        this.UPDATE(tableName);
        List<Object> values = new ArrayList();
        if (bean instanceof Map) {
            values = this.mapToSql(bean, true);
            values.add(((Map)bean).get("id"));
        } else {
            List<String> methodNames = this.addFieldValues(bean, true, null);
            for (String methodName : methodNames) {
                values.add(ExecuteMethod.executeMethod((Object)bean, (String)methodName, (Object[])new Object[0]));
            }
            values.add(ExecuteMethod.executeMethod((Object)bean, (String)"getId", (Object[])new Object[0]));
        }
        this.WHERE("id = ?");
        return values.toArray();
    }

    private List<Object> mapToSql(Object bean, boolean isSet) {
        ArrayList<Object> values = new ArrayList<Object>();
        Map map = (Map)bean;
        for (String field : map.keySet()) {
            if (field.equals("id")) continue;
            if (isSet) {
                this.SET(field + " = ?");
            } else {
                this.VALUES(field, "?");
            }
            values.add(map.get(field));
        }
        return values;
    }

    private List<String> addFieldValues(Object bean, boolean isSet, Map<String, String> fieldMapping) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Method method : bean.getClass().getMethods()) {
            String methodName = method.getName();
            if (!CommonSQL.isOk_field(methodName)) continue;
            try {
                if (method.invoke(bean, new Object[0]) == null) continue;
                fieldNames.add(methodName);
                String pojoName = BeanUtil.getFieldName((String)methodName, (String)"get");
                if (fieldMapping != null && fieldMapping.size() > 0 && fieldMapping.containsKey(pojoName)) {
                    pojoName = fieldMapping.get(pojoName);
                }
                if (isSet) {
                    this.SET(pojoName + " = ?");
                    continue;
                }
                this.VALUES(pojoName, "?");
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.warning((Throwable)e);
            }
        }
        return fieldNames;
    }

    private static boolean isOk_field(String methodName) {
        return (methodName.startsWith("get") || methodName.startsWith("is")) && !"getId".equals(methodName) && !"getClass".equals(methodName) && !"getService".equals(methodName);
    }
}

