/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jdbc.sqlbuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SQLStatement {
    StatementType statementType;
    List<String> sets = new ArrayList<String>();
    List<String> select = new ArrayList<String>();
    List<String> tables = new ArrayList<String>();
    List<String> join = new ArrayList<String>();
    List<String> innerJoin = new ArrayList<String>();
    List<String> outerJoin = new ArrayList<String>();
    List<String> leftOuterJoin = new ArrayList<String>();
    List<String> rightOuterJoin = new ArrayList<String>();
    List<String> where = new ArrayList<String>();
    List<String> having = new ArrayList<String>();
    List<String> groupBy = new ArrayList<String>();
    List<String> orderBy = new ArrayList<String>();
    List<String> lastList = new ArrayList<String>();
    List<String> columns = new ArrayList<String>();
    List<String> values = new ArrayList<String>();
    boolean distinct;

    private void sqlClause(SafeAppendable builder, String keyword, List<String> parts, String open, String close, String conjunction) {
        if (!parts.isEmpty()) {
            if (!builder.isEmpty()) {
                builder.append("\n");
            }
            builder.append(keyword);
            builder.append(" ");
            builder.append(open);
            String last = "________";
            int n = parts.size();
            for (int i = 0; i < n; ++i) {
                String part = parts.get(i);
                if (!(i <= 0 || part.equals(") \nAND (") || part.equals(") \nOR (") || last.equals(") \nAND (") || last.equals(") \nOR ("))) {
                    builder.append(conjunction);
                }
                builder.append(part);
                last = part;
            }
            builder.append(close);
        }
    }

    private String selectSQL(SafeAppendable builder) {
        if (this.distinct) {
            this.sqlClause(builder, "SELECT DISTINCT", this.select, "", "", ", ");
        } else {
            this.sqlClause(builder, "SELECT", this.select, "", "", ", ");
        }
        this.sqlClause(builder, "FROM", this.tables, "", "", ", ");
        this.sqlClause(builder, "JOIN", this.join, "", "", "\nJOIN ");
        this.sqlClause(builder, "INNER JOIN", this.innerJoin, "", "", "\nINNER JOIN ");
        this.sqlClause(builder, "OUTER JOIN", this.outerJoin, "", "", "\nOUTER JOIN ");
        this.sqlClause(builder, "LEFT OUTER JOIN", this.leftOuterJoin, "", "", "\nLEFT OUTER JOIN ");
        this.sqlClause(builder, "RIGHT OUTER JOIN", this.rightOuterJoin, "", "", "\nRIGHT OUTER JOIN ");
        this.sqlClause(builder, "WHERE", this.where, "(", ")", " AND ");
        this.sqlClause(builder, "GROUP BY", this.groupBy, "", "", ", ");
        this.sqlClause(builder, "HAVING", this.having, "(", ")", " AND ");
        this.sqlClause(builder, "ORDER BY", this.orderBy, "", "", ", ");
        return builder.toString();
    }

    private String insertSQL(SafeAppendable builder) {
        this.sqlClause(builder, "INSERT INTO", this.tables, "", "", "");
        this.sqlClause(builder, "", this.columns, "(", ")", ", ");
        this.sqlClause(builder, "VALUES", this.values, "(", ")", ", ");
        return builder.toString();
    }

    private String deleteSQL(SafeAppendable builder) {
        this.sqlClause(builder, "DELETE FROM", this.tables, "", "", "");
        this.sqlClause(builder, "WHERE", this.where, "(", ")", " AND ");
        return builder.toString();
    }

    private String updateSQL(SafeAppendable builder) {
        this.sqlClause(builder, "UPDATE", this.tables, "", "", "");
        this.sqlClause(builder, "SET", this.sets, "", "", ", ");
        this.sqlClause(builder, "WHERE", this.where, "(", ")", " AND ");
        return builder.toString();
    }

    public String sql(Appendable a) {
        String answer;
        SafeAppendable builder = new SafeAppendable(a);
        if (this.statementType == null) {
            return null;
        }
        switch (this.statementType) {
            case DELETE: {
                answer = this.deleteSQL(builder);
                break;
            }
            case INSERT: {
                answer = this.insertSQL(builder);
                break;
            }
            case SELECT: {
                answer = this.selectSQL(builder);
                break;
            }
            case UPDATE: {
                answer = this.updateSQL(builder);
                break;
            }
            default: {
                answer = null;
            }
        }
        return answer;
    }

    public static class SafeAppendable {
        private final Appendable a;
        private boolean empty = true;

        public SafeAppendable(Appendable a) {
            this.a = a;
        }

        public SafeAppendable append(CharSequence s) {
            try {
                if (this.empty && s.length() > 0) {
                    this.empty = false;
                }
                this.a.append(s);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }

    public static enum StatementType {
        DELETE,
        INSERT,
        SELECT,
        UPDATE;

    }
}

