/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jdbc.sqlbuilder;

import com.ajaxjs.jdbc.sqlbuilder.SQLStatement;

public class SqlBuilder {
    public static final String AND = ") \nAND (";
    public static final String OR = ") \nOR (";
    private SQLStatement sql = new SQLStatement();

    public SqlBuilder UPDATE(String table) {
        this.sql().statementType = SQLStatement.StatementType.UPDATE;
        this.sql().tables.add(table);
        return this;
    }

    public SqlBuilder SET(String sets) {
        this.sql().sets.add(sets);
        return this;
    }

    public SqlBuilder INSERT_INTO(String tableName) {
        this.sql().statementType = SQLStatement.StatementType.INSERT;
        this.sql().tables.add(tableName);
        return this;
    }

    public SqlBuilder VALUES(String columns, String values) {
        this.sql().columns.add(columns);
        this.sql().values.add(values);
        return this;
    }

    public SqlBuilder SELECT(String columns) {
        this.sql().statementType = SQLStatement.StatementType.SELECT;
        this.sql().select.add(columns);
        return this;
    }

    public SqlBuilder SELECT_DISTINCT(String columns) {
        this.sql().distinct = true;
        this.SELECT(columns);
        return this;
    }

    public SqlBuilder DELETE_FROM(String table) {
        this.sql().statementType = SQLStatement.StatementType.DELETE;
        this.sql().tables.add(table);
        return this;
    }

    public SqlBuilder FROM(String table) {
        this.sql().tables.add(table);
        return this;
    }

    public SqlBuilder JOIN(String join) {
        this.sql().join.add(join);
        return this;
    }

    public SqlBuilder INNER_JOIN(String join) {
        this.sql().innerJoin.add(join);
        return this;
    }

    public SqlBuilder LEFT_OUTER_JOIN(String join) {
        this.sql().leftOuterJoin.add(join);
        return this;
    }

    public SqlBuilder RIGHT_OUTER_JOIN(String join) {
        this.sql().rightOuterJoin.add(join);
        return this;
    }

    public SqlBuilder OUTER_JOIN(String join) {
        this.sql().outerJoin.add(join);
        return this;
    }

    public SqlBuilder WHERE(String conditions) {
        this.sql().where.add(conditions);
        this.sql().lastList = this.sql().where;
        return this;
    }

    public SqlBuilder OR() {
        this.sql().lastList.add(OR);
        return this;
    }

    public SqlBuilder AND() {
        this.sql().lastList.add(AND);
        return this;
    }

    public SqlBuilder GROUP_BY(String columns) {
        this.sql().groupBy.add(columns);
        return this;
    }

    public SqlBuilder HAVING(String conditions) {
        this.sql().having.add(conditions);
        this.sql().lastList = this.sql().having;
        return this;
    }

    public SqlBuilder ORDER_BY(String columns) {
        this.sql().orderBy.add(columns);
        return this;
    }

    private SQLStatement sql() {
        return this.sql;
    }

    public <A extends Appendable> A usingAppender(A a) {
        this.sql().sql(a);
        return a;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.sql().sql(sb);
        return sb.toString();
    }
}

