/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.config;

import com.ajaxjs.Version;
import com.ajaxjs.config.Config;
import com.ajaxjs.config.SiteStruService;
import com.ajaxjs.js.JsEngineWrapper;
import com.ajaxjs.js.JsonHelper;
import com.ajaxjs.js.JsonStruTraveler;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.Value;
import com.ajaxjs.util.io.FileUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.util.Map;

public class ConfigService {
    private static final LogHelper LOGGER = LogHelper.getLog(SiteStruService.class);
    public static Config config;
    public static Map<String, Object> flatConfig;
    public static String jsonPath;
    public static String jsonSchemePath;

    public Config getConfig() {
        return config;
    }

    public Map<String, Object> getFlatConfig() {
        return flatConfig;
    }

    public static void load() {
        ConfigService.load(jsonPath);
    }

    public static void load(String jsonPath) {
        ConfigService.jsonPath = jsonPath;
        config = new Config();
        config.setJsonPath(jsonPath);
        config.setJsonStr(FileUtil.openAsText((String)jsonPath));
        config.putAll(JsonHelper.parseMap((String)config.getJsonStr()));
        config.setLoaded(true);
        flatConfig = JsonStruTraveler.flatMap((Map)config);
    }

    public static void save() {
        String jsonStr = JsonHelper.stringifyMap((Map)config);
        config.setJsonStr(jsonStr);
        ((FileUtil)new FileUtil().setFilePath(config.getJsonPath()).setContent(jsonStr)).save();
    }

    public static boolean getValueAsBool(String key) {
        return true;
    }

    public static int getValueAsInt(String key) {
        Object number = flatConfig.get(key);
        if (number instanceof Double) {
            number = Value.double2int((Double)((Double)number));
        }
        return (Integer)Value.TypeConvert((Object)number, Integer.TYPE);
    }

    public static String getValueAsString(String key) {
        return (String)Value.TypeConvert((Object)flatConfig.get(key), String.class);
    }

    public static String transform(String namespace) {
        String[] arr = namespace.split("\\.");
        if (arr.length < 1) {
            return null;
        }
        String[] arr2 = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr2[i] = "[\"" + arr[i] + "\"]";
        }
        return StringUtil.stringJoin((String[])arr2, (String)"");
    }

    public static void loadJSON_in_JS(Map<String, Object> map) {
        JsEngineWrapper js = new JsEngineWrapper();
        js.eval("allConfig = " + FileUtil.openAsText((String)jsonPath));
        for (String key : map.keySet()) {
            String jsKey = ConfigService.transform(key);
            String jsCode = "";
            if (map.get(key) == null) {
                jsCode = String.format("allConfig%s = null;", jsKey);
            } else {
                String type;
                switch (type = (String)js.eval("typeof allConfig" + jsKey, String.class)) {
                    case "string": {
                        jsCode = String.format("allConfig%s = '%s';", jsKey, map.get(key));
                        break;
                    }
                    case "number": 
                    case "boolean": {
                        jsCode = String.format("allConfig%s = %s;", jsKey, map.get(key));
                        break;
                    }
                    case "object": {
                        jsCode = String.format("allConfig%s = '%s';", jsKey, map.get(key));
                    }
                    default: {
                        LOGGER.info("\u672a\u5904\u7406 js \u7c7b\u578b\uff1a " + type);
                    }
                }
            }
            js.eval(jsCode);
        }
        String json = (String)js.eval("JSON.stringify(allConfig);", String.class);
        FileUtil.save((String)jsonPath, (String)json);
    }

    static {
        jsonPath = Version.srcFolder + "site_config.json";
        jsonSchemePath = Version.srcFolder + "site_config_scheme.json";
    }
}

