/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.mvc.controller;

import com.ajaxjs.ioc.BeanContext;
import com.ajaxjs.mvc.controller.Action;
import com.ajaxjs.mvc.controller.IController;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.reflect.NewInstance;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.mvc.annotation.Controller;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;

public class ControllerScanner {
    private static final LogHelper LOGGER = LogHelper.getLog(ControllerScanner.class);
    public static Map<String, Action> urlMappingTree = new HashMap<String, Action>();

    public static void add(Class<? extends IController> clz) {
        if (!ControllerScanner.testClass(clz)) {
            return;
        }
        String topPath = clz.getAnnotation(Path.class).value();
        topPath = topPath.replaceAll("^/", "");
        LOGGER.info("This controller \"{0}\" is being parsing", new Object[]{topPath});
        Action action = null;
        if (topPath.contains("/")) {
            action = ControllerScanner.findKey(urlMappingTree, ControllerScanner.split2Queue(topPath), "");
        } else if (urlMappingTree.containsKey(topPath)) {
            action = urlMappingTree.get(topPath);
        } else {
            action = new Action();
            urlMappingTree.put(topPath, action);
        }
        if (BeanContext.isIOC_Bean(clz)) {
            action.controller = (IController)BeanContext.me().getBeanByClass(clz);
            if (action.controller == null) {
                LOGGER.warning("\u5728 IOC \u8d44\u6e90\u5e93\u4e2d\u627e\u4e0d\u5230\u8be5\u7c7b {0} \u7684\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u8be5\u7c7b\u662f\u5426\u5df2\u7ecf\u52a0\u5165\u4e86 IOC \u626b\u63cf\uff1f", new Object[]{clz.getName()});
            }
        } else {
            action.controller = (IController)NewInstance.newInstance(clz, (Object[])new Object[0]);
        }
        ControllerScanner.parseSubPath(clz, action);
        LOGGER.info("The controller \"{0}\" was parsed and registered", new Object[]{topPath});
    }

    public static Action find(String path) {
        Queue<String> queue = ControllerScanner.split2Queue(path);
        return ControllerScanner.findKey(urlMappingTree, queue, "");
    }

    private static Queue<String> split2Queue(String path) {
        String[] arr = path.split("/");
        return new LinkedList<String>(Arrays.asList(arr));
    }

    private static void parseSubPath(Class<? extends IController> clz, Action action) {
        for (Method method : clz.getMethods()) {
            Path subPath = method.getAnnotation(Path.class);
            if (subPath != null) {
                String subPathValue = subPath.value();
                subPathValue = subPathValue.replaceAll("^/", "");
                if (action.children == null) {
                    action.children = new HashMap<String, Action>();
                }
                Action subAction = ControllerScanner.findKey(action.children, ControllerScanner.split2Queue(subPathValue), action.path + "/");
                subAction.controller = action.controller;
                ControllerScanner.methodSend(method, subAction);
                continue;
            }
            ControllerScanner.methodSend(method, action);
        }
    }

    private static void methodSend(Method method, Action action) {
        if (method.getAnnotation(GET.class) != null) {
            if (ControllerScanner.testIfEmpty(action.getMethod, action.path, "GET")) {
                action.getMethod = method;
            }
        } else if (method.getAnnotation(POST.class) != null) {
            if (ControllerScanner.testIfEmpty(action.postMethod, action.path, "POST")) {
                action.postMethod = method;
            }
        } else if (method.getAnnotation(PUT.class) != null) {
            if (ControllerScanner.testIfEmpty(action.putMethod, action.path, "PUT")) {
                action.putMethod = method;
            }
        } else if (method.getAnnotation(DELETE.class) != null && ControllerScanner.testIfEmpty(action.deleteMethod, action.path, "DELETE")) {
            action.deleteMethod = method;
        }
    }

    private static boolean testIfEmpty(Method method, String path, String httpMethod) {
        if (method == null) {
            return true;
        }
        LOGGER.warning("\u63a7\u5236\u5668\u4e0a\u7684 {0} \u7684 {1} \u65b9\u6cd5\u4e1a\u5df2\u767b\u8bb0\uff0c\u4e0d\u63a5\u53d7\u91cd\u590d\u767b\u8bb0\uff01", new Object[]{path, httpMethod});
        return false;
    }

    private static Action findKey(Map<String, Action> urlMappingTree, Queue<String> queue, String path) {
        while (!queue.isEmpty()) {
            Action a2;
            Action action;
            String key = queue.poll();
            path = path + key + "/";
            if (urlMappingTree.containsKey(key)) {
                action = urlMappingTree.get(key);
                if (queue.isEmpty()) {
                    return action;
                }
                if (action.children != null) {
                    Action action2 = ControllerScanner.findKey(action.children, queue, path);
                    if (action2 == null) continue;
                    return action2;
                }
                if (action.children == null) {
                    action.children = new HashMap<String, Action>();
                    a2 = ControllerScanner.findKey(action.children, queue, path);
                    if (a2 == null) continue;
                    return a2;
                }
                LOGGER.warning("happened if sth wrong.");
                continue;
            }
            action = new Action();
            action.path = path.replaceAll(".$", "");
            urlMappingTree.put(key, action);
            if (queue.isEmpty()) {
                return action;
            }
            action.children = new HashMap<String, Action>();
            a2 = ControllerScanner.findKey(action.children, queue, path);
            if (a2 == null) continue;
            return a2;
        }
        return null;
    }

    public static boolean testClass(Class<? extends IController> clz) {
        if (clz.getAnnotation(Controller.class) == null) {
            return false;
        }
        Path path = clz.getAnnotation(Path.class);
        if (path == null) {
            LOGGER.warning("{0} \u4e0d\u5b58\u5728\u4efb\u4f55 Path \u4fe1\u606f\uff01No Path info!", new Object[]{clz.toString()});
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isController(Class<?> clazz) {
        for (Class<?> clz : clazz.getInterfaces()) {
            if (clz != IController.class) continue;
            return true;
        }
        return false;
    }
}

