/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.mvc.controller;

import com.ajaxjs.ioc.BeanContext;
import com.ajaxjs.mvc.ModelAndView;
import com.ajaxjs.mvc.controller.Action;
import com.ajaxjs.mvc.controller.ControllerScanner;
import com.ajaxjs.mvc.controller.IController;
import com.ajaxjs.mvc.controller.MvcOutput;
import com.ajaxjs.mvc.controller.MvcRequest;
import com.ajaxjs.mvc.controller.RequestParam;
import com.ajaxjs.mvc.filter.FilterAction;
import com.ajaxjs.mvc.filter.MvcFilter;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.collection.CollectionUtil;
import com.ajaxjs.util.io.resource.Scan;
import com.ajaxjs.util.io.resource.ScanClass;
import com.ajaxjs.util.io.resource.Scanner;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.reflect.ExecuteMethod;
import com.ajaxjs.util.reflect.NewInstance;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MvcDispatcher
implements Filter {
    private static final LogHelper LOGGER = LogHelper.getLog(MvcDispatcher.class);
    private static final Pattern id = Pattern.compile("/\\d+/");
    private static final Pattern p = Pattern.compile("\\.jpg|\\.png|\\.gif|\\.js|\\.css|\\.ico|\\.jpeg|\\.htm|\\.swf|\\.txt|\\.mp4|\\.flv");

    public void init(FilterConfig fConfig) throws ServletException {
        LOGGER.info("AJAXJS MVC \u670d\u52a1\u542f\u52a8\u4e4b\u4e2d\u2026\u2026");
        Map<String, String> config = MvcRequest.parseInitParams(null, fConfig);
        MvcDispatcher.doIoc(config);
        MvcDispatcher.scannController(config);
    }

    private static void doIoc(Map<String, String> config) {
        if (config == null) {
            return;
        }
        String _doIoc = config.get("doIoc");
        if (_doIoc != null) {
            String doIoc = _doIoc;
            for (String packageName : StringUtil.split((String)doIoc)) {
                BeanContext.me().init(packageName);
            }
        }
    }

    private static void scannController(Map<String, String> config) {
        if (config != null && config.get("controller") != null) {
            String str = config.get("controller");
            IControllerScanner cS = new IControllerScanner();
            for (String packageName : StringUtil.split((String)str)) {
                Scanner scaner = new Scanner((Scan)cS);
                Set IControllers = scaner.scan(packageName);
                for (Class clz : IControllers) {
                    ControllerScanner.add(clz);
                }
            }
        } else {
            LOGGER.info("web.xml \u6ca1\u6709\u914d\u7f6e MVC \u8fc7\u6ee4\u5668\u6216\u8005 \u914d\u7f6e\u6ca1\u6709\u5b9a\u4e49 controller");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest _request = (HttpServletRequest)req;
        HttpServletResponse _response = (HttpServletResponse)resp;
        if (MvcDispatcher.isStaticAsset(_request.getRequestURI())) {
            chain.doFilter(req, resp);
            return;
        }
        MvcRequest request = new MvcRequest(_request);
        MvcOutput response = new MvcOutput(_response);
        String uri = request.getFolder();
        String httpMethod = request.getMethod();
        Matcher match = id.matcher(uri);
        if (match.find()) {
            uri = match.replaceAll("/{id}/");
        }
        Action action = ControllerScanner.find(uri);
        Method method = MvcDispatcher.getMethod(action, httpMethod);
        IController controller = action.controller;
        if (method != null && controller != null) {
            MvcDispatcher.dispatch(request, response, controller, method);
            return;
        }
        chain.doFilter(req, resp);
    }

    private static void dispatch(MvcRequest request, MvcOutput response, IController controller, Method method) {
        MvcRequest.setHttpServletRequest((HttpServletRequest)request);
        MvcRequest.setHttpServletResponse((HttpServletResponse)response);
        Object[] filterActions = MvcDispatcher.getFilterActions(method);
        boolean isDoFilter = !CollectionUtil.isNull((Object[])filterActions);
        boolean isSkip = false;
        Throwable filterEx = null;
        if (isDoFilter) {
            try {
                for (Object filterAction : filterActions) {
                    isSkip = !filterAction.before(request, response, controller);
                }
            }
            catch (Throwable e) {
                isSkip = true;
                filterEx = e;
            }
        }
        Object result = null;
        ModelAndView model = null;
        if (!isSkip) {
            if (method.getParameterTypes().length > 0) {
                Object[] args = RequestParam.getArgs(request, (HttpServletResponse)response, method);
                model = MvcDispatcher.findModel(args);
                result = ExecuteMethod.executeMethod((Object)controller, (Method)method, (Object[])args);
            } else {
                result = ExecuteMethod.executeMethod((Object)controller, (Method)method, (Object[])new Object[0]);
            }
        }
        if (isDoFilter) {
            for (Object filterAction : filterActions) {
                filterAction.after(request, response, controller, isSkip, filterEx);
            }
        }
        if (!isSkip) {
            response.resultHandler(result, request, model);
        }
        MvcRequest.clean();
    }

    private static FilterAction[] getFilterActions(Method method) {
        FilterAction[] filterActions = null;
        if (method.getAnnotation(MvcFilter.class) != null) {
            Class<? extends FilterAction>[] clzs = method.getAnnotation(MvcFilter.class).before();
            filterActions = new FilterAction[clzs.length];
            int i = 0;
            for (Class<? extends FilterAction> clz : clzs) {
                filterActions[i++] = (FilterAction)NewInstance.newInstance(clz, (Object[])new Object[0]);
            }
        }
        return filterActions;
    }

    public static boolean isStaticAsset(String requestURI) {
        return p.matcher(requestURI).find();
    }

    private static Method getMethod(Action action, String httpMethod) {
        if (action == null) {
            throw new NullPointerException("Action \u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
        }
        switch (httpMethod.toUpperCase()) {
            case "GET": {
                return action.getMethod;
            }
            case "POST": {
                return action.postMethod;
            }
            case "PUT": {
                return action.putMethod;
            }
            case "DELETE": {
                return action.deleteMethod;
            }
        }
        return null;
    }

    private static ModelAndView findModel(Object[] args) {
        for (Object obj : args) {
            if (!(obj instanceof ModelAndView)) continue;
            return (ModelAndView)obj;
        }
        return null;
    }

    public void destroy() {
    }

    public static class IControllerScanner
    extends ScanClass {
        public void onFileAdding(Set target, File resourceFile, String packageJavaName) {
            String className = IControllerScanner.getClassName((File)resourceFile, (String)packageJavaName);
            Class clazz = NewInstance.getClassByName((String)className);
            if (IController.class.isAssignableFrom(clazz)) {
                target.add(clazz);
            }
        }

        public void onJarAdding(Set target, String resourcePath) {
            Class clazz = NewInstance.getClassByName((String)resourcePath);
            if (IController.class.isAssignableFrom(clazz)) {
                target.add(clazz);
            }
        }
    }
}

