/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.mvc.controller;

import com.ajaxjs.js.JsonHelper;
import com.ajaxjs.mvc.ModelAndView;
import com.ajaxjs.mvc.controller.MvcDispatcher;
import com.ajaxjs.mvc.controller.MvcRequest;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.PageContext;

public class MvcOutput
extends HttpServletResponseWrapper {
    private static final LogHelper LOGGER = LogHelper.getLog(MvcDispatcher.class);
    private String output;
    private Map<String, ?> output_Map;
    private Object output_Obj;
    private String content_Type = "text/html";
    private String redirect;
    private String template;
    private boolean json;
    private String jsonpToken;
    private boolean simpleHTML;
    public static final String returnJs_refresh = "window.location = document.referrer;";

    public MvcOutput(HttpServletResponse request) {
        super(request);
    }

    public void go() {
        if (this.getRedirect() != null) {
            try {
                this.sendRedirect(this.getRedirect());
            }
            catch (IOException e) {
                LOGGER.warning((Throwable)e);
            }
            return;
        }
        if (this.getOutput_Map() != null) {
            this.setJson(true).setOutput(JsonHelper.stringifyMap(this.getOutput_Map()));
        } else if (this.getOutput_Obj() != null) {
            // empty if block
        }
        if (this.isJson()) {
            this.setContent_Type("application/json");
        } else if (this.getJsonpToken() != null) {
            this.setContent_Type("application/javascript");
            this.setOutput(String.format("%s(%s);", this.getJsonpToken(), this.getOutput()));
        } else if (this.isSimpleHTML()) {
            this.setOutput(String.format("<html><meta charset=\"utf-8\" /><body>%s</body></html>", this.getOutput()));
        }
        this.output(this.getOutput());
    }

    public void go(HttpServletRequest request) {
        if (this.getTemplate() != null) {
            request.setAttribute("jsp_path", (Object)this.getTemplate());
            try {
                RequestDispatcher rd = request.getRequestDispatcher(this.getTemplate());
                if (rd != null) {
                    rd.forward((ServletRequest)request, (ServletResponse)this);
                }
            }
            catch (IOException | ServletException e) {
                LOGGER.warning(e);
            }
        }
    }

    public void resultHandler(Object result, MvcRequest request, ModelAndView model) {
        if (model != null) {
            request.saveToReuqest(model);
        }
        if (result != null && result instanceof String) {
            String str = (String)result;
            String html = "html::";
            if (str.startsWith(html)) {
                this.setSimpleHTML(true).setOutput(str.replace(html, "")).go();
            } else if (str.startsWith("redirect::")) {
                this.setRedirect(str.replace("redirect::", "")).go();
            } else if (str.startsWith("json::")) {
                String jsonpToken = request.getParameter("callback");
                if (StringUtil.isEmptyString((String)jsonpToken)) {
                    this.setJson(true).setOutput(str.replace("json::", "")).go();
                } else {
                    this.setJsonpToken(jsonpToken).setOutput(str.replace("json::", "")).go();
                }
            } else {
                if (!str.endsWith(".jsp")) {
                    str = str + ".jsp";
                }
                LOGGER.info("\u6267\u884c\u903b\u8f91\u5b8c\u6210\uff0c\u73b0\u5728\u63a7\u5236\u8f93\u51fa\uff08\u54cd\u5e94 JSP\uff09" + result);
                this.setTemplate(str).go((HttpServletRequest)request);
            }
        }
    }

    public void go(RenderedImage im) {
        if (this.getContent_Type() != null) {
            this.setContentType(this.getContent_Type());
        }
        try {
            ImageIO.write(im, "JPEG", (OutputStream)this.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.warning((Throwable)e);
        }
    }

    public static void fix(PageContext pageContext) {
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        try {
            ServletOutputStream out = response.getOutputStream();
            out.flush();
            out.close();
            response.flushBuffer();
            pageContext.getOut().clear();
            pageContext.pushBody();
        }
        catch (IOException e) {
            LOGGER.warning((Throwable)e);
        }
    }

    public void output(String output) {
        PrintWriter writer = null;
        this.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        this.setContentType(this.getContent_Type());
        try {
            writer = this.getWriter();
        }
        catch (IOException e) {
            LOGGER.warning((Throwable)e);
        }
        if (writer != null) {
            writer.print(output);
        }
    }

    public MvcOutput noCache() {
        this.setHeader("Pragma", "No-cache");
        this.setHeader("Cache-Control", "no-cache");
        this.setDateHeader("Expires", 0L);
        return this;
    }

    public String getOutput() {
        return this.output;
    }

    public MvcOutput setOutput(String output) {
        this.output = output;
        return this;
    }

    public String getContent_Type() {
        return this.content_Type;
    }

    public MvcOutput setContent_Type(String content_Type) {
        this.content_Type = content_Type;
        return this;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public MvcOutput setRedirect(String redirect) {
        this.redirect = redirect;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public MvcOutput setTemplate(String template) {
        this.template = template;
        return this;
    }

    public boolean isJson() {
        return this.json;
    }

    public MvcOutput setJson(boolean json) {
        this.json = json;
        return this;
    }

    public boolean isSimpleHTML() {
        return this.simpleHTML;
    }

    public MvcOutput setSimpleHTML(boolean simpleHTML) {
        this.simpleHTML = simpleHTML;
        return this;
    }

    public String getJsonpToken() {
        return this.jsonpToken;
    }

    public MvcOutput setJsonpToken(String jsonpToken) {
        this.jsonpToken = jsonpToken;
        return this;
    }

    public Map<String, ?> getOutput_Map() {
        return this.output_Map;
    }

    public MvcOutput setOutput_Map(Map<String, ?> output_Map) {
        this.output_Map = output_Map;
        return this;
    }

    public Object getOutput_Obj() {
        return this.output_Obj;
    }

    public MvcOutput setOutput_Obj(Object output_Obj) {
        this.output_Obj = output_Obj;
        return this;
    }
}

