/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.mvc.controller;

import com.ajaxjs.framework.dao.QueryParams;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.collection.MapHelper;
import com.ajaxjs.util.io.StreamUtil;
import com.ajaxjs.util.reflect.BeanUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class MvcRequest
extends HttpServletRequestWrapper {
    public static final String callback_param = "callback";
    private static ThreadLocal<HttpServletRequest> threadLocalRequest = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> threadLocalResponse = new ThreadLocal();

    public MvcRequest(HttpServletRequest request) {
        super(request);
        try {
            this.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRequestURI() {
        Object obj = this.getAttribute("javax.servlet.forward.request_uri");
        if (obj != null && !StringUtil.isEmptyString((String)((String)obj))) {
            return (String)obj;
        }
        return super.getRequestURI();
    }

    public String getRoute() {
        String route = this.getRequestURI().replace(this.getContextPath(), "");
        return route.replaceFirst("/\\w+\\.\\w+$", "");
    }

    public String getFolder() {
        return this.getRequestURI().replace(this.getContextPath(), "").replaceFirst("^/", "").replaceFirst("/\\w+\\.\\w+$", "");
    }

    public Map<String, Object> getPutRequestData() {
        try {
            String params = ((StreamUtil)((StreamUtil)((StreamUtil)new StreamUtil().setIn((InputStream)this.getInputStream())).byteStream2stringStream()).close()).getContent();
            return MapHelper.toMap((String[])params.split("&"), (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getValueFromPath(String value, String paramName) {
        String result;
        String requestURI = this.getRequestURI().replace(this.getContextPath(), "");
        String regExp = "(" + value.replace("{" + paramName + "}", ")(\\d+)");
        Matcher m = Pattern.compile(regExp).matcher(requestURI);
        String string = result = m.find() ? m.group(m.groupCount()) : null;
        if (result == null) {
            throw new IllegalArgumentException("\u5728 " + requestURI + "\u4e0d\u80fd\u83b7\u53d6 " + paramName + "\u53c2\u6570");
        }
        return result;
    }

    public <T> T getBean(Class<T> clazz) {
        Map<String, Object> map = this.getMethod() != null && this.getMethod().toUpperCase().equals("PUT") ? this.getPutRequestData() : MapHelper.asObject((Map)MapHelper.toMap((Map)this.getParameterMap()), (boolean)true);
        return (T)BeanUtil.map2Bean(map, clazz, (boolean)true);
    }

    public static Map<String, String> parseInitParams(ServletConfig servletCfg, FilterConfig filterCfg) {
        Enumeration initParams;
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enumeration = initParams = servletCfg == null ? filterCfg.getInitParameterNames() : servletCfg.getInitParameterNames();
        while (initParams.hasMoreElements()) {
            String key = (String)initParams.nextElement();
            String value = servletCfg == null ? filterCfg.getInitParameter(key) : servletCfg.getInitParameter(key);
            map.put(key, value);
        }
        return map;
    }

    public void saveToReuqest(Map<String, Object> map) {
        for (String key : map.keySet()) {
            this.setAttribute(key, map.get(key));
        }
    }

    public static QueryParams factory() {
        return new QueryParams(MvcRequest.getHttpServletRequest().getParameterMap());
    }

    public static void setHttpServletRequest(HttpServletRequest request) {
        threadLocalRequest.set(request);
    }

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest request = threadLocalRequest.get();
        if (request == null) {
            throw new RuntimeException("\u8bf7\u6c42\u5bf9\u8c61\u672a\u521d\u59cb\u5316");
        }
        return request;
    }

    public static void setHttpServletResponse(HttpServletResponse response) {
        threadLocalResponse.set(response);
    }

    public static HttpServletResponse getHttpServletResponse() {
        HttpServletResponse resp = threadLocalResponse.get();
        if (resp == null) {
            throw new RuntimeException("\u54cd\u5e94\u5bf9\u8c61\u672a\u521d\u59cb\u5316");
        }
        return resp;
    }

    public static void clean() {
        threadLocalRequest.set(null);
        threadLocalResponse.set(null);
    }
}

