/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.simpleApp;

import com.ajaxjs.Version;
import com.ajaxjs.config.ConfigService;
import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.framework.dao.QueryParams;
import com.ajaxjs.framework.service.IService;
import com.ajaxjs.framework.service.ServiceException;
import com.ajaxjs.jdbc.JdbcConnection;
import com.ajaxjs.jdbc.PageResult;
import com.ajaxjs.js.JsonHelper;
import com.ajaxjs.mvc.ModelAndView;
import com.ajaxjs.mvc.controller.IController;
import com.ajaxjs.mvc.controller.MvcRequest;
import com.ajaxjs.simpleApp.Constant;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;

public abstract class CommonController<T, ID extends Serializable, S extends IService<T, ID>>
implements IController,
Constant {
    private static final LogHelper LOGGER = LogHelper.getLog(CommonController.class);
    private S service;

    public static void initDb(String connStr) {
        try {
            if (JdbcConnection.getConnection() == null || JdbcConnection.getConnection().isClosed()) {
                DataSource ds = JdbcConnection.getDataSource((String)connStr);
                Connection conn = JdbcConnection.getConnection((DataSource)ds);
                JdbcConnection.setConnection((Connection)conn);
                LOGGER.info("\u542f\u52a8\u6570\u636e\u5e93\u94fe\u63a5\u2026\u2026" + conn);
            }
        }
        catch (SQLException e) {
            LOGGER.warning((Throwable)e);
        }
    }

    public static void initDb() {
        String config = ConfigService.getValueAsString("data.database_node");
        if (config == null) {
            config = "jdbc/mysql";
        }
        if (!Version.isDebug) {
            config = config + "_deploy";
        }
        CommonController.initDb(config);
    }

    public static void closeDb() {
        Connection conn = JdbcConnection.getConnection();
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warning((Throwable)e);
        }
        JdbcConnection.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<T> pageList(int start, int limit, ModelAndView model) {
        LOGGER.info("\u83b7\u53d6\u5217\u8868 GET list:{0}/{1}", new Object[]{start, limit});
        CommonController.initDb();
        this.prepareData(model);
        S service = this.getService();
        PageResult pageResult = null;
        try {
            pageResult = service.findPagedList(CommonController.getParam(start, limit));
            model.put("PageResult", pageResult);
        }
        catch (Throwable e) {
            model.put("errMsg", CommonController.getUnderLayerErr(e));
        }
        finally {
            CommonController.closeDb();
        }
        if (model.get("errMsg") != null) {
            LOGGER.warning("\u4e25\u91cd\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5 service.findPagedList() \u662f\u5426\u7ed9\u51fa\u5b9e\u73b0");
        }
        return pageResult;
    }

    public static Throwable getUnderLayerErr(Throwable e) {
        while (e.getClass().equals(InvocationTargetException.class) || e.getClass().equals(UndeclaredThrowableException.class)) {
            e = e.getCause();
        }
        return e;
    }

    public String outputPagedJsonList(PageResult<T> pageResult, ModelAndView model) {
        if (model.get("errMsg") != null) {
            return "/asset/common/jsp/json/json-err.jsp";
        }
        if (pageResult != null && pageResult.getRows() != null) {
            String jsonStr;
            if (pageResult.getRows().get(0) instanceof Map) {
                List list = pageResult.getRows();
                jsonStr = JsonHelper.stringifyListMap((List)list);
            } else {
                jsonStr = JsonHelper.beans2json((List)pageResult.getRows());
            }
            model.put("MapOutput", jsonStr);
        }
        return "/asset/common/jsp/json/json-pagedList.jsp";
    }

    public static QueryParams getParam(int start, int limit) {
        HttpServletRequest request = MvcRequest.getHttpServletRequest();
        QueryParams param = new QueryParams(start, limit, request.getParameterMap());
        return param;
    }

    public void prepareData(ModelAndView model) {
        model.put("requestTimeRecorder", System.currentTimeMillis());
        if (this.service != null) {
            model.put("uiName", this.service.getName());
            model.put("tableName", this.service.getTableName());
        }
    }

    public String info(ID id, ModelAndView model) {
        LOGGER.info("\u8bfb\u53d6\u5355\u4e2a\u8bb0\u5f55\u6216\u8005\u7f16\u8f91\u67d0\u4e2a\u8bb0\u5f55\uff1aid \u662f {0}", new Object[]{id});
        CommonController.initDb();
        this.prepareData(model);
        S service = this.getService();
        try {
            Object entry = service.findById(id);
            model.put("info", entry);
        }
        catch (ServiceException e) {
            model.put("errMsg", e);
        }
        return String.format("/asset/jsp/%s/info", service.getTableName());
    }

    public void list_all(ModelAndView model) {
        LOGGER.info("----\u83b7\u53d6\u5168\u90e8\u5217\u8868----");
        this.pageList(0, 999, model);
    }

    public static void saveToReuqest(ModelAndView mv, HttpServletRequest request) {
        for (String key : mv.keySet()) {
            request.setAttribute(key, mv.get(key));
        }
    }

    public String createUI(ModelAndView model) {
        LOGGER.info("\u65b0\u5efa\u8bb0\u5f55UI");
        S service = this.getService();
        this.prepareData(model);
        model.put("actionName", "\u65b0\u5efa");
        model.put("isCreate", true);
        return String.format("/asset/jsp/%s/admin-info", service.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(T entity, ModelAndView model) {
        LOGGER.info("\u4fee\u6539 name:{0}\uff0c\u6570\u636e\u5e93\u5c06\u6267\u884c INSERT \u64cd\u4f5c", new Object[]{entity});
        CommonController.initDb();
        try {
            Serializable newlyId = this.getService().create(entity);
            if (newlyId == null) {
                throw new ServiceException("\u521b\u5efa\u5931\u8d25\uff01");
            }
            model.put("newlyId", newlyId);
        }
        catch (ServiceException e) {
            model.put("errMsg", e);
        }
        finally {
            CommonController.closeDb();
        }
        return "/asset/common/jsp/json/json-cud.jsp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String update(ID id, T entity, ModelAndView model) {
        LOGGER.info("\u4fee\u6539 name:{0}\uff0c\u6570\u636e\u5e93\u5c06\u6267\u884c UPDATE \u64cd\u4f5c", new Object[]{entity});
        model.put("isUpdate", true);
        if (entity instanceof Map) {
            ((Map)entity).put("id", id);
        } else {
            ((BaseModel)entity).setId((Long)id);
        }
        CommonController.initDb();
        try {
            this.getService().update(entity);
        }
        catch (ServiceException e) {
            model.put("errMsg", e);
        }
        finally {
            CommonController.closeDb();
        }
        return "/asset/common/jsp/json/json-cud.jsp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String delete(T entry, ModelAndView model) {
        LOGGER.info("\u5220\u9664 id:{0}\uff0c\u6570\u636e\u5e93\u5c06\u6267\u884c DELETE \u64cd\u4f5c", new Object[]{entry});
        CommonController.initDb();
        try {
            if (!this.getService().delete(entry)) {
                throw new ServiceException("\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        catch (ServiceException e) {
            String string = String.format("json::{\"isOk\": false, \"msg\" : \"%s\"}", "\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + (Object)((Object)e));
            return string;
        }
        finally {
            CommonController.closeDb();
        }
        return String.format("json::{\"isOk\": true, \"msg\" : \"%s\"}", "\u5220\u9664\u6210\u529f");
    }

    public String delete(ID id, ModelAndView model) {
        HashMap<String, ID> map = new HashMap<String, ID>();
        map.put("id", id);
        return this.delete((ID)map, model);
    }

    public static String outputListMapAsJson(List<Map<String, Object>> result) {
        if (result != null && result.size() > 0) {
            return "json::{\"result\":" + JsonHelper.stringifyListMap(result) + "}";
        }
        return "json::{\"result\": null}";
    }

    public static String outputListBeanAsJson(List<? extends BaseModel> result) {
        if (result != null && result.size() > 0) {
            String[] str = new String[result.size()];
            for (int i = 0; i < result.size(); ++i) {
                str[i] = JsonHelper.bean2json((Object)result.get(i));
            }
            return "json::{\"result\":[" + StringUtil.stringJoin((String[])str, (String)",") + "]}";
        }
        return "json::{\"result\": null}";
    }

    public static String show405() {
        return String.format("json::{\"isOk\": false, \"msg\" : \"%s\"}", "405\uff0c Request method not supported \u7981\u6b62\u64cd\u4f5c");
    }

    public S getService() {
        if (this.service == null) {
            throw new NullPointerException("\u6ca1\u6709\u4e1a\u52a1\u5c42\u5bf9\u8c61\uff01");
        }
        return this.service;
    }

    public void setService(S service) {
        if (service == null) {
            LOGGER.warning("\u5f53\u524d\u6ca1\u6709 service \u5bf9\u8c61\u4f20\u5165\uff01\uff01\uff01");
        }
        this.service = service;
    }
}

