/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web;

import com.ajaxjs.Version;
import com.ajaxjs.config.SiteStruService;
import com.ajaxjs.util.collection.MapHelper;
import com.ajaxjs.web.WebUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HtmlHead {
    HttpServletRequest request;
    private UserAgent ua;
    Map<String, Object> node;
    private static String localIp = null;

    public void init(HttpServletRequest request) {
        this.request = request;
        this.setUa(new UserAgent(request));
        this.node = SiteStruService.getPageNode(request.getRequestURI(), request.getContextPath());
    }

    public Map<String, Object> getNode() {
        return this.node;
    }

    public UserAgent getUa() {
        return this.ua;
    }

    public void setUa(UserAgent ua) {
        this.ua = ua;
    }

    public String getCssUrl(String lessPath) {
        return this.getCssUrl(lessPath, Version.isDebug);
    }

    public String getCssUrl(String lessPath, boolean isDebug) {
        if (lessPath == null) {
            lessPath = "/asset/less/main.less";
        }
        if (isDebug) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("lessFile", WebUtil.Mappath(this.request, lessPath));
            params.put("ns", WebUtil.Mappath(this.request, lessPath.replaceAll("\\/[\\w\\.]*$", "")));
            params.put("picPath", WebUtil.getBasePath(this.request) + "/asset");
            params.put("MainDomain", "");
            params.put("isdebug", "true");
            return "http://" + HtmlHead.getLocalIp() + ":83/lessService/?" + MapHelper.join(params, (String)"&");
        }
        return this.request.getContextPath() + lessPath.replace("/less", "/css").replace(".less", ".css");
    }

    public static String getLocalIp() {
        if (localIp == null) {
            for (String ip : WebUtil.getAllLocalHostIP()) {
                if (!ip.startsWith("192.168.") && !ip.startsWith("10.0.")) continue;
                localIp = ip;
                break;
            }
            if (localIp == null) {
                localIp = "localhost";
            }
        }
        return localIp;
    }

    public boolean isOldIE() {
        return this.getUa().isIE() && this.getUa().is_old_IE();
    }

    public boolean isDebug() {
        return Version.isDebug;
    }

    public static class UserAgent {
        private String ua;

        public UserAgent(String ua) {
            this.ua = ua;
        }

        public UserAgent(HttpServletRequest request) {
            String ua = request.getHeader("User-Agent");
            if (ua != null) {
                this.ua = ua.toLowerCase();
            }
        }

        public boolean isIE() {
            return this.ua.contains("msie");
        }

        public boolean is_old_IE() {
            return this.isIE() && (this.ua.contains("msie 5.5") || this.ua.contains("msie 6.0") || this.ua.contains("msie 7.0") || this.ua.contains("msie 8.0"));
        }

        public boolean isFireFox() {
            return this.ua.contains("firefox");
        }

        public boolean isChrome() {
            return this.ua.contains("chrome");
        }

        public boolean isAndroid() {
            return this.ua.contains("android");
        }

        public boolean isAndroid_7() {
            boolean is7 = Pattern.compile("Android\\s7", 2).matcher(this.ua).find();
            return this.isAndroid() && is7;
        }

        public boolean isAndroid_6() {
            boolean is6 = Pattern.compile("Android\\s6", 2).matcher(this.ua).find();
            return this.isAndroid() && is6;
        }

        public boolean isAndroid_5() {
            boolean is5 = Pattern.compile("Android\\s5", 2).matcher(this.ua).find();
            return this.isAndroid() && is5;
        }

        public boolean isAndroid_4() {
            boolean is4 = Pattern.compile("Android\\s4", 2).matcher(this.ua).find();
            return this.isAndroid() && is4;
        }

        public boolean isAndroid_2() {
            boolean is2 = Pattern.compile("Android\\s2", 2).matcher(this.ua).find();
            return this.isAndroid() && is2;
        }

        public boolean isAndroid_2_2() {
            boolean is2_2 = Pattern.compile("Android\\s2\\.2", 2).matcher(this.ua).find();
            return this.isAndroid() && is2_2;
        }

        public boolean isIPhone() {
            return this.ua.contains("iphone");
        }

        public boolean isIPad() {
            return this.ua.contains("ipad");
        }

        public boolean isIOS() {
            return this.isIPad() || this.isIPhone();
        }

        public boolean isWinPhone() {
            return this.ua.contains("windows phone");
        }

        public boolean isPhone() {
            return this.isAndroid() || this.isIOS() || this.isWinPhone();
        }
    }
}

