/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web;

import com.ajaxjs.util.Encode;
import com.ajaxjs.util.StringUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpBasicAuthFilter
implements Filter {
    private static final LogHelper LOGGER = LogHelper.getLog(HttpBasicAuthFilter.class);
    private static final String userid = "admin";
    private static String pwd = "123123";

    public void init(FilterConfig config) throws ServletException {
        LOGGER.info("\u542f\u52a8 HTTP BasicAuth \u540e\u53f0\u7ba1\u7406");
        if (config.getInitParameter("adminPassword") != null) {
            pwd = config.getInitParameter("adminPassword");
        }
    }

    public void doFilter(ServletRequest _request, ServletResponse _response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)_request;
        HttpServletResponse response = (HttpServletResponse)_response;
        if (!HttpBasicAuthFilter.checkAuth(request)) {
            String msg = "\"Please input your account\"";
            response.setCharacterEncoding("utf-8");
            response.setStatus(401, "Authentication Required");
            response.setHeader("WWW-Authenticate", "Basic realm=" + msg);
            response.setCharacterEncoding("utf-8");
            response.getWriter().append("<meta charset=\"utf-8\" />Please login! \u8bf7\u767b\u5f55\u7cfb\u7edf\uff01");
            LOGGER.info("HTTP BasicAuth \u767b\u5f55\u5931\u8d25\uff01");
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    private static boolean checkAuth(HttpServletRequest request) {
        return HttpBasicAuthFilter.checkAuth(request.getHeader("Authorization"), userid, pwd);
    }

    private static boolean isBadArray(String[] arr) {
        return arr == null || arr.length != 2;
    }

    private static boolean checkAuth(String authorization, String username, String password) {
        if (StringUtil.isEmptyString((String)authorization)) {
            return false;
        }
        String[] basicArray = authorization.split("\\s+");
        if (HttpBasicAuthFilter.isBadArray(basicArray)) {
            return false;
        }
        String idpass = Encode.base64Decode((String)basicArray[1]);
        if (StringUtil.isEmptyString((String)idpass)) {
            return false;
        }
        String[] idpassArray = idpass.split(":");
        if (HttpBasicAuthFilter.isBadArray(idpassArray)) {
            return false;
        }
        return username.equalsIgnoreCase(idpassArray[0]) && password.equalsIgnoreCase(idpassArray[1]);
    }
}

